package net.polyv.seminar.v1.entity.channel;

import java.util.Date;
import java.util.List;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.seminar.v1.entity.SeminarPageCommonResponse;

/**
 * 获取直播间观众统计数据响应实体
 * @author jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("获取直播间观众统计数据响应实体")
public class SeminarGetCdnViewLogResponse extends SeminarPageCommonResponse {
    
    /**
     * 观众统计数据
     */
    @ApiModelProperty(name = "contents", value = "观众统计数据【详见contents字段说明】", required = false)
    private List<SeminarGetCdnViewLogResponse.ViewLog> contents;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("观众统计数据")
    public static class ViewLog {
        
        /**
         * 用户ID
         */
        @ApiModelProperty(name = "viewerId", value = "用户ID", required = false)
        @JSONField(name = "param1")
        private String viewerId;
        
        /**
         * 用户昵称
         */
        @ApiModelProperty(name = "viewerName", value = "用户昵称", required = false)
        @JSONField(name = "param2")
        private String viewerName;
        
        /**
         * 观看类型 vod:回放; live:直播
         */
        @ApiModelProperty(name = "logType", value = "观看类型 vod:回放; live:直播", required = false)
        @JSONField(name = "param3")
        private String logType;
        
        /**
         * 地区
         */
        @ApiModelProperty(name = "province", value = "地区", required = false)
        private String province;
        
        /**
         * 城市
         */
        @ApiModelProperty(name = "city", value = "城市", required = false)
        private String city;
        
        /**
         * 观众IP
         */
        @ApiModelProperty(name = "ipAddress", value = "观众IP", required = false)
        private String ipAddress;
        
        /**
         * 进入时间
         */
        @ApiModelProperty(name = "createdTime", value = "进入时间", required = false)
        private Date createdTime;
        
        /**
         * 退出时间
         */
        @ApiModelProperty(name = "endTime", value = "退出时间", required = false)
        private Date endTime;
        
        /**
         * 观看时长（单位：秒）
         */
        @ApiModelProperty(name = "playDuration", value = "观看时长（单位：秒）", required = false)
        private Integer playDuration;
        
        /**
         * 观看终端
         */
        @ApiModelProperty(name = "browser", value = "观看终端", required = false)
        private String browser;
        
        /**
         * 场次
         */
        @ApiModelProperty(name = "sessionId", value = "场次", required = false)
        private String sessionId;
    }
}