package net.polyv.seminar.v1.entity.channel;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.seminar.v1.entity.SeminarCommonRequest;

/**
 * 批量删除频道请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("批量删除频道请求实体")
public class SeminarBatchDeleteChannelRequest extends SeminarCommonRequest {
    
    /**
     * 请求体参数，频道号列表，每次最多删除100个频道
     */
    @ApiModelProperty(name = "channelIds", value = "请求体参数，频道号列表，每次最多删除100个频道， 必须放在请求体中", required = true)
    @NotNull(message = "属性channelIds不能为空")
    private List<String> channelIds;
    
}