package net.polyv.seminar.v1.entity.auth;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.seminar.v1.entity.SeminarCommonRequest;

/**
 * 修改研讨会参会条件请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("修改研讨会参会条件请求实体")
public class SeminarSetAuthSettingRequest extends SeminarCommonRequest {
    
    /**
     * 频道号，不传为全局设置
     */
    @ApiModelProperty(name = "channelId", value = "频道号，不传为全局设置", required = false)
    private String channelId;
    
    /**
     * 观看条件设置 【详见authSettings字段说明】
     */
    @ApiModelProperty(name = "authSettings", value = "观看条件设置 【详见authSettings字段说明】", required = true)
    @NotNull(message = "属性authSettings不能为空")
    private List<AuthSetting> authSettings;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("观看条件设置")
    public static class AuthSetting {
        
        /**
         * 主要观看条件为1，次要观看条件为2
         */
        @ApiModelProperty(name = "rank", value = "主要观看条件为1，次要观看条件为2", required = true)
        @NotNull(message = "属性rank不能为空")
        private Integer rank;
        
        /**
         * 是否开启条件观看 N：关闭 Y：开启
         */
        @ApiModelProperty(name = "enabled", value = "是否开启条件观看 N：关闭 Y：开启", required = true)
        @NotNull(message = "属性enabled不能为空")
        private String enabled;
        
        /**
         * 角色 host：主持人 attendee：参会人
         */
        @ApiModelProperty(name = "roleCode", value = "角色 host：主持人 attendee：参会人", required = true)
        @NotNull(message = "属性roleCode不能为空")
        private String roleCode;
        
        /**
         * 参会条件类型 password：密码登录 direct：独立授权
         */
        @ApiModelProperty(name = "authType", value = "参会条件类型 password：密码登录 direct：独立授权", required = false)
        private String authType;
        
        /**
         * 当authType为password时，密码登录的password
         */
        @ApiModelProperty(name = "password", value = "当authType为password时，密码登录的password", required = false)
        private String password;
        
        /**
         * 当authType为direct时，设置参数，非必填，独立授权SecretKey
         */
        @ApiModelProperty(name = "directKey", value = "当authType为direct时，设置参数，非必填，独立授权SecretKey", required = false)
        private String directKey;
    }
}