package net.polyv.seminar.v1.constant;

/**
 * 研讨会相关URL
 * @author: jiangyifan
 */
public class SeminarURL {
    
    private static boolean isHttps = true;
    
    /**
     * POLYV live api base uri
     */
    private static final String BASE_URI = "api.polyv.net/live/";
    
    /**
     * 设置自定义域名
     */
    private static String customUri = "";
    
    /**
     * url 替换通配符
     */
    private static final String PARAM_REPLACE_CHAR = "%s";
    
    /**
     * 400错误码
     */
    public static final int CODE_400 = 400;
    
    /**
     * 200响应码
     */
    public static final int CODE_200 = 200;
    
    /**
     * 请求错误提示
     */
    public static final String REQUEST_ERR_MSG = "Bad Request";
    
    /**
     * 设置代理错误提示
     */
    public static final String PROXY_ERR_MSG = "Proxy Error";
    
    /**
     * 获取替换参数后的URL地址
     * @param format 格式化
     * @param param 格式参数
     * @return 格式化后字符串
     */
    public static String getRealUrl(String format, Object... param) {
        return String.format(format, param);
    }
    
    public static boolean getIsHttps() {
        return isHttps;
    }
    
    /**
     * 设置直播API协议为http
     */
    public static void setSeminarHttpProtocol() {
        isHttps = false;
    }
    
    /**
     * 设置直播API协议为https
     */
    public static void setSeminarHttpsProtocol() {
        isHttps = true;
    }
    
    public static String getCustomUri() {
        return customUri;
    }
    
    /**
     * 设置自定义域名
     */
    public static void setCustomUri(String customUri) {
        SeminarURL.customUri = customUri;
    }
    
    /**
     * 创建研讨会频道(旧版后台)
     */
    public static final String SEMINAR_CREATE_CHANNEL_URL = BASE_URI + "v3/channel/basic/create";
    
    /**
     * 创建研讨会频道(新版后台)
     */
    public static final String SEMINAR_CREATE_CHANNEL_V2_URL = BASE_URI + "v4/channel/create";
    
    /**
     * 获取研讨会频道录制设置
     */
    public static final String SEMINAR_GET_RECORD_URL = BASE_URI + "v3/channel/seminar/setting/get-record";
    
    /**
     * 获取研讨会直播间参会者统计数据
     */
    public static final String SEMINAR_GET_VIEW_LOG_URL = BASE_URI + "v3/channel/seminar/statistics/listViewLogs";
    
    /**
     * 获取直播间观众统计数据
     */
    public static final String SEMINAR_GET_CDN_VIEW_LOG_URL = BASE_URI + "v3/channel/statistics/listViewLogs";
    
    /**
     * 删除单个频道
     */
    public static final String SEMINAR_DELETE_CHANNEL_URL = BASE_URI + "v2/channels/" + PARAM_REPLACE_CHAR + "/delete";
    
    /**
     * 批量删除频道
     */
    public static final String SEMINAR_DELETE_CHANNEL_BATCH_URL = BASE_URI + "v3/channel/basic/batch-delete";
    
    /**
     * 查询录制视频
     */
    public static final String SEMINAR_GET_RECORD_FILES_URL =
            BASE_URI + "v2/channels/" + PARAM_REPLACE_CHAR + "/recordFiles";
    
    /**
     * 删除录制视频
     */
    public static final String SEMINAR_DELETE_RECORD_FILES_URL =
            BASE_URI + "v2/channel/recordFile/" + PARAM_REPLACE_CHAR + "/delete-record";
    
    /**
     * 查询研讨会参会条件
     */
    public static final String SEMINAR_GET_SEMINAR_AUTH_URL = BASE_URI + "v3/channel/seminar/setting/auth/get";
    
    /**
     * 修改研讨会参会条件
     */
    public static final String SEMINAR_SET_SEMINAR_AUTH_URL = BASE_URI + "v3/channel/seminar/setting/auth/set";
    
}
