package net.polyv.seminar.v1.config;

import net.polyv.common.v1.base.HttpClientUtil;
import net.polyv.common.v1.exception.GlobalUncaughtExceptionHandler;

/**
 * 研讨会全局配置类
 * @author: jiangyifan
 */
public class SeminarGlobalConfig {
    private SeminarGlobalConfig() {
    }
    
    private static String APP_ID = "";
    private static String USER_ID = "";
    private static String APP_SECRET = "";
    public static final String SDK_NAME = "JAVA_SEMINAR_SDK";
    
    public static String getAppId() {
        return APP_ID;
    }
    
    public static String getUserId() {
        return USER_ID;
    }
    
    public static String getAppSecret() {
        return APP_SECRET;
    }
    
    
    /**
     * 系统全局初始化
     * @param appId appId
     * @param userId userId
     * @param appSecret appSecret
     */
    public static void init(String appId, String userId, String appSecret) {
        SeminarGlobalConfig.APP_ID = appId;
        SeminarGlobalConfig.USER_ID = userId;
        SeminarGlobalConfig.APP_SECRET = appSecret;
        HttpClientUtil.init();
        //全局异常和错误处理配置
        Thread.setDefaultUncaughtExceptionHandler(new GlobalUncaughtExceptionHandler());
    }
    
    /**
     * 系统全局初始化
     * @param appId appId
     * @param userId userId
     * @param appSecret appSecret
     * @param timeOut timeOut
     * @param maxClientNum maxClientNum
     */
    public static void init(String appId, String userId, String appSecret, Integer timeOut, Integer maxClientNum) {
        SeminarGlobalConfig.APP_ID = appId;
        SeminarGlobalConfig.USER_ID = userId;
        SeminarGlobalConfig.APP_SECRET = appSecret;
        HttpClientUtil.setTimeOut(timeOut);
        HttpClientUtil.setMaxClientNum(maxClientNum);
        HttpClientUtil.init();
        //全局异常和错误处理配置
        Thread.setDefaultUncaughtExceptionHandler(new GlobalUncaughtExceptionHandler());
    }
    
    /**
     * 系统全局初始化
     * @param appId appId
     * @param userId userId
     * @param appSecret appSecret
     * @param hostName 代理地址
     * @param port 代理端口
     * @param scheme 协议，默认为http
     */
    public static void init(String appId, String userId, String appSecret, String hostName, int port, String scheme) {
        SeminarGlobalConfig.APP_ID = appId;
        SeminarGlobalConfig.USER_ID = userId;
        SeminarGlobalConfig.APP_SECRET = appSecret;
        HttpClientUtil.init(hostName, port, scheme);
        //全局异常和错误处理配置
        Thread.setDefaultUncaughtExceptionHandler(new GlobalUncaughtExceptionHandler());
    }
    
    /**
     * 系统全局初始化
     * @param appId appId
     * @param userId userId
     * @param appSecret appSecret
     * @param timeOut 超时时间
     * @param maxClientNum 链接池最大并发连接数
     * @param hostName 代理地址
     * @param port 代理端口
     * @param scheme 协议，默认为http
     */
    public static void init(String appId, String userId, String appSecret, Integer timeOut, Integer maxClientNum,
            String hostName, int port, String scheme) {
        SeminarGlobalConfig.APP_ID = appId;
        SeminarGlobalConfig.USER_ID = userId;
        SeminarGlobalConfig.APP_SECRET = appSecret;
        HttpClientUtil.setTimeOut(timeOut);
        HttpClientUtil.setMaxClientNum(maxClientNum);
        HttpClientUtil.init(hostName, port, scheme);
        //全局异常和错误处理配置
        Thread.setDefaultUncaughtExceptionHandler(new GlobalUncaughtExceptionHandler());
    }
}
