/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report.internal.html;

import java.io.IOException;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.internal.AbstractGroupVisitor;
import org.jacoco.report.internal.ReportOutputFolder;
import org.jacoco.report.internal.html.IHTMLReportContext;
import org.jacoco.report.internal.html.page.BundlePage;
import org.jacoco.report.internal.html.page.GroupPage;
import org.jacoco.report.internal.html.page.NodePage;
import org.jacoco.report.internal.html.page.ReportPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLGroupVisitor
extends AbstractGroupVisitor {
    private final ReportOutputFolder folder;
    private final IHTMLReportContext context;
    private final GroupPage page;

    public HTMLGroupVisitor(ReportPage parent, ReportOutputFolder folder, IHTMLReportContext context, String name) {
        super(name);
        this.folder = folder;
        this.context = context;
        this.page = new GroupPage(this.total, parent, folder, context);
    }

    public NodePage<ICoverageNode> getPage() {
        return this.page;
    }

    @Override
    protected void handleBundle(IBundleCoverage bundle2, ISourceFileLocator locator) throws IOException {
        BundlePage bundlepage = new BundlePage(bundle2, this.page, locator, this.folder.subFolder(bundle2.getName()), this.context);
        bundlepage.render();
        this.page.addItem(bundlepage);
    }

    @Override
    protected AbstractGroupVisitor handleGroup(String name) throws IOException {
        HTMLGroupVisitor handler = new HTMLGroupVisitor(this.page, this.folder.subFolder(name), this.context, name);
        this.page.addItem(handler.getPage());
        return handler;
    }

    @Override
    protected void handleEnd() throws IOException {
        this.page.render();
    }
}

