/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.maven;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;
import org.jacoco.core.runtime.AgentOptions;
import org.jacoco.maven.AbstractJacocoMojo;

public abstract class AbstractAgentMojo
extends AbstractJacocoMojo {
    static final String AGENT_ARTIFACT_NAME = "org.jacoco:org.jacoco.agent";
    static final String TYCHO_ARG_LINE = "tycho.testArgLine";
    static final String SUREFIRE_ARG_LINE = "argLine";
    @Parameter(property="plugin.artifactMap", required=true, readonly=true)
    Map<String, Artifact> pluginArtifactMap;
    @Parameter(property="jacoco.propertyName")
    String propertyName;
    @Parameter(property="jacoco.append")
    Boolean append;
    @Parameter(property="jacoco.exclClassLoaders")
    String exclClassLoaders;
    @Parameter(property="jacoco.inclBootstrapClasses")
    Boolean inclBootstrapClasses;
    @Parameter(property="jacoco.inclNoLocationClasses")
    Boolean inclNoLocationClasses;
    @Parameter(property="jacoco.sessionId")
    String sessionId;
    @Parameter(property="jacoco.dumpOnExit")
    Boolean dumpOnExit;
    @Parameter(property="jacoco.output")
    String output;
    @Parameter(property="jacoco.address")
    String address;
    @Parameter(property="jacoco.port")
    Integer port;
    @Parameter(property="jacoco.classDumpDir")
    File classDumpDir;
    @Parameter(property="jacoco.jmx")
    Boolean jmx;

    public void executeMojo() {
        String name = this.getEffectivePropertyName();
        Properties projectProperties = this.getProject().getProperties();
        String oldValue = projectProperties.getProperty(name);
        String newValue = this.createAgentOptions().prependVMArguments(oldValue, this.getAgentJarFile());
        this.getLog().info(name + " set to " + newValue);
        projectProperties.setProperty(name, newValue);
    }

    protected void skipMojo() {
        String name = this.getEffectivePropertyName();
        Properties projectProperties = this.getProject().getProperties();
        String oldValue = projectProperties.getProperty(name);
        if (oldValue == null) {
            this.getLog().info(name + " set to empty");
            projectProperties.setProperty(name, "");
        }
    }

    File getAgentJarFile() {
        Artifact jacocoAgentArtifact = this.pluginArtifactMap.get(AGENT_ARTIFACT_NAME);
        return jacocoAgentArtifact.getFile();
    }

    AgentOptions createAgentOptions() {
        AgentOptions agentOptions = new AgentOptions();
        agentOptions.setDestfile(this.getDestFile().getAbsolutePath());
        if (this.append != null) {
            agentOptions.setAppend(this.append);
        }
        if (this.getIncludes() != null && !this.getIncludes().isEmpty()) {
            String agentIncludes = StringUtils.join(this.getIncludes().iterator(), ":");
            agentOptions.setIncludes(agentIncludes);
        }
        if (this.getExcludes() != null && !this.getExcludes().isEmpty()) {
            String agentExcludes = StringUtils.join(this.getExcludes().iterator(), ":");
            agentOptions.setExcludes(agentExcludes);
        }
        if (this.exclClassLoaders != null) {
            agentOptions.setExclClassloader(this.exclClassLoaders);
        }
        if (this.inclBootstrapClasses != null) {
            agentOptions.setInclBootstrapClasses(this.inclBootstrapClasses);
        }
        if (this.inclNoLocationClasses != null) {
            agentOptions.setInclNoLocationClasses(this.inclNoLocationClasses);
        }
        if (this.sessionId != null) {
            agentOptions.setSessionId(this.sessionId);
        }
        if (this.dumpOnExit != null) {
            agentOptions.setDumpOnExit(this.dumpOnExit);
        }
        if (this.output != null) {
            agentOptions.setOutput(this.output);
        }
        if (this.address != null) {
            agentOptions.setAddress(this.address);
        }
        if (this.port != null) {
            agentOptions.setPort(this.port);
        }
        if (this.classDumpDir != null) {
            agentOptions.setClassDumpDir(this.classDumpDir.getAbsolutePath());
        }
        if (this.jmx != null) {
            agentOptions.setJmx(this.jmx);
        }
        return agentOptions;
    }

    String getEffectivePropertyName() {
        if (this.isPropertyNameSpecified()) {
            return this.propertyName;
        }
        if (this.isEclipseTestPluginPackaging()) {
            return TYCHO_ARG_LINE;
        }
        return SUREFIRE_ARG_LINE;
    }

    boolean isPropertyNameSpecified() {
        return this.propertyName != null && !"".equals(this.propertyName);
    }

    boolean isEclipseTestPluginPackaging() {
        return "eclipse-test-plugin".equals(this.getProject().getPackaging());
    }

    abstract File getDestFile();
}

