/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.model.fileset.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.io.logging.DefaultMessageHolder;
import org.apache.maven.shared.io.logging.MessageHolder;
import org.apache.maven.shared.io.logging.MojoLogSink;
import org.apache.maven.shared.io.logging.PlexusLoggerSink;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.mappers.FileNameMapper;
import org.apache.maven.shared.model.fileset.mappers.MapperException;
import org.apache.maven.shared.model.fileset.mappers.MapperUtil;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

public class FileSetManager {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final boolean verbose;
    private MessageHolder messages;

    public FileSetManager(Log log, boolean verbose) {
        this.messages = verbose ? new DefaultMessageHolder(0, 1, new MojoLogSink(log)) : new DefaultMessageHolder(1, 1, new MojoLogSink(log));
        this.verbose = verbose;
    }

    public FileSetManager(Log log) {
        this.messages = new DefaultMessageHolder(1, 1, new MojoLogSink(log));
        this.verbose = false;
    }

    public FileSetManager(Logger log, boolean verbose) {
        this.messages = verbose ? new DefaultMessageHolder(0, 1, new PlexusLoggerSink(log)) : new DefaultMessageHolder(1, 1, new PlexusLoggerSink(log));
        this.verbose = verbose;
    }

    public FileSetManager(Logger log) {
        this.messages = new DefaultMessageHolder(1, 1, new PlexusLoggerSink(log));
        this.verbose = false;
    }

    public FileSetManager() {
        this.verbose = false;
    }

    public Map mapIncludedFiles(FileSet fileSet) throws MapperException {
        String[] sourcePaths = this.getIncludedFiles(fileSet);
        LinkedHashMap<String, String> mappedPaths = new LinkedHashMap<String, String>();
        FileNameMapper fileMapper = MapperUtil.getFileNameMapper(fileSet.getMapper());
        for (int i = 0; i < sourcePaths.length; ++i) {
            String sourcePath = sourcePaths[i];
            String destPath = fileMapper != null ? fileMapper.mapFileName(sourcePath) : sourcePath;
            mappedPaths.put(sourcePath, destPath);
        }
        return mappedPaths;
    }

    public String[] getIncludedFiles(FileSet fileSet) {
        DirectoryScanner scanner = this.scan(fileSet);
        if (scanner != null) {
            return scanner.getIncludedFiles();
        }
        return EMPTY_STRING_ARRAY;
    }

    public String[] getIncludedDirectories(FileSet fileSet) {
        DirectoryScanner scanner = this.scan(fileSet);
        if (scanner != null) {
            return scanner.getIncludedDirectories();
        }
        return EMPTY_STRING_ARRAY;
    }

    public String[] getExcludedFiles(FileSet fileSet) {
        DirectoryScanner scanner = this.scan(fileSet);
        if (scanner != null) {
            return scanner.getExcludedFiles();
        }
        return EMPTY_STRING_ARRAY;
    }

    public String[] getExcludedDirectories(FileSet fileSet) {
        DirectoryScanner scanner = this.scan(fileSet);
        if (scanner != null) {
            return scanner.getExcludedDirectories();
        }
        return EMPTY_STRING_ARRAY;
    }

    public void delete(FileSet fileSet) throws IOException {
        this.delete(fileSet, true);
    }

    public void delete(FileSet fileSet, boolean throwsError) throws IOException {
        Set deletablePaths = this.findDeletablePaths(fileSet);
        if (this.messages != null && this.messages.isDebugEnabled()) {
            this.messages.addDebugMessage("Found deletable paths: " + String.valueOf(deletablePaths).replace(',', '\n')).flush();
        }
        LinkedList<String> warnMessages = new LinkedList<String>();
        Iterator it = deletablePaths.iterator();
        while (it.hasNext()) {
            String message;
            String path = (String)it.next();
            File file = new File(fileSet.getDirectory(), path);
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                if (fileSet.isFollowSymlinks() || !this.isSymlink(file)) {
                    if (this.verbose && this.messages != null) {
                        this.messages.addInfoMessage("Deleting directory: " + file).flush();
                    }
                    this.removeDir(file, fileSet.isFollowSymlinks(), throwsError, warnMessages);
                    continue;
                }
                if (this.verbose && this.messages != null) {
                    this.messages.addInfoMessage("Deleting symlink to directory: " + file).flush();
                }
                if (file.delete()) continue;
                message = "Unable to delete symlink " + file.getAbsolutePath();
                if (throwsError) {
                    throw new IOException(message);
                }
                if (warnMessages.contains(message)) continue;
                warnMessages.add(message);
                continue;
            }
            if (this.verbose && this.messages != null) {
                this.messages.addInfoMessage("Deleting file: " + file).flush();
            }
            if (this.delete(file)) continue;
            message = "Failed to delete file " + file.getAbsolutePath() + ". Reason is unknown.";
            if (throwsError) {
                throw new IOException(message);
            }
            warnMessages.add(message);
        }
        if (this.messages != null && this.messages.isWarningEnabled() && !throwsError && warnMessages.size() > 0) {
            it = warnMessages.iterator();
            while (it.hasNext()) {
                String msg = (String)it.next();
                this.messages.addWarningMessage(msg).flush();
            }
        }
    }

    private boolean isSymlink(File file) throws IOException {
        File fileInCanonicalParent = null;
        File parentDir = file.getParentFile();
        fileInCanonicalParent = parentDir == null ? file : new File(parentDir.getCanonicalPath(), file.getName());
        if (this.messages != null && this.messages.isDebugEnabled()) {
            this.messages.addDebugMessage("Checking for symlink:\nFile's canonical path: " + fileInCanonicalParent.getCanonicalPath() + "\nFile's absolute path with canonical parent: " + fileInCanonicalParent.getPath()).flush();
        }
        return !fileInCanonicalParent.getCanonicalFile().equals(fileInCanonicalParent.getAbsoluteFile());
    }

    private Set findDeletablePaths(FileSet fileSet) {
        Set includes = this.findDeletableDirectories(fileSet);
        includes.addAll(this.findDeletableFiles(fileSet, includes));
        return includes;
    }

    private Set findDeletableDirectories(FileSet fileSet) {
        DirectoryScanner scanner;
        if (this.verbose && this.messages != null) {
            this.messages.addInfoMessage("Scanning for deletable directories.").flush();
        }
        if ((scanner = this.scan(fileSet)) == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> includes = new HashSet<String>(Arrays.asList(scanner.getIncludedDirectories()));
        ArrayList<String> excludes = new ArrayList<String>(Arrays.asList(scanner.getExcludedDirectories()));
        ArrayList<String> linksForDeletion = new ArrayList<String>();
        if (!fileSet.isFollowSymlinks()) {
            if (this.verbose && this.messages != null) {
                this.messages.addInfoMessage("Adding symbolic link dirs which were previously excluded to the list being deleted.").flush();
            }
            scanner.setFollowSymlinks(true);
            scanner.scan();
            if (this.messages != null && this.messages.isDebugEnabled()) {
                this.messages.addDebugMessage("Originally marked for delete: " + includes).flush();
                this.messages.addDebugMessage("Marked for preserve (with followSymlinks == false): " + excludes).flush();
            }
            List<String> includedDirsAndSymlinks = Arrays.asList(scanner.getIncludedDirectories());
            linksForDeletion.addAll(excludes);
            linksForDeletion.retainAll(includedDirsAndSymlinks);
            if (this.messages != null && this.messages.isDebugEnabled()) {
                this.messages.addDebugMessage("Symlinks marked for deletion (originally mismarked): " + linksForDeletion).flush();
            }
            excludes.removeAll(includedDirsAndSymlinks);
        }
        this.excludeParentDirectoriesOfExcludedPaths(excludes, includes);
        includes.addAll(linksForDeletion);
        return includes;
    }

    private Set findDeletableFiles(FileSet fileSet, Set deletableDirectories) {
        DirectoryScanner scanner;
        if (this.verbose && this.messages != null) {
            this.messages.addInfoMessage("Re-scanning for deletable files.").flush();
        }
        if ((scanner = this.scan(fileSet)) == null) {
            return deletableDirectories;
        }
        Set includes = deletableDirectories;
        includes.addAll(Arrays.asList(scanner.getIncludedFiles()));
        ArrayList<String> excludes = new ArrayList<String>(Arrays.asList(scanner.getExcludedFiles()));
        ArrayList<String> linksForDeletion = new ArrayList<String>();
        if (!fileSet.isFollowSymlinks()) {
            if (this.verbose && this.messages != null) {
                this.messages.addInfoMessage("Adding symbolic link files which were previously excluded to the list being deleted.").flush();
            }
            scanner.setFollowSymlinks(true);
            scanner.scan();
            if (this.messages != null && this.messages.isDebugEnabled()) {
                this.messages.addDebugMessage("Originally marked for delete: " + includes).flush();
                this.messages.addDebugMessage("Marked for preserve (with followSymlinks == false): " + excludes).flush();
            }
            List<String> includedFilesAndSymlinks = Arrays.asList(scanner.getIncludedFiles());
            linksForDeletion.addAll(excludes);
            linksForDeletion.retainAll(includedFilesAndSymlinks);
            if (this.messages != null && this.messages.isDebugEnabled()) {
                this.messages.addDebugMessage("Symlinks marked for deletion (originally mismarked): " + linksForDeletion).flush();
            }
            excludes.removeAll(includedFilesAndSymlinks);
        }
        this.excludeParentDirectoriesOfExcludedPaths(excludes, includes);
        includes.addAll(linksForDeletion);
        return includes;
    }

    private void excludeParentDirectoriesOfExcludedPaths(Collection excludedPaths, Set deletablePaths) {
        Iterator it = excludedPaths.iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            String parentPath = new File(path).getParent();
            while (parentPath != null) {
                boolean removed;
                if (this.messages != null && this.messages.isDebugEnabled()) {
                    this.messages.addDebugMessage("Verifying path " + parentPath + " is not present; contains file which is excluded.").flush();
                }
                if ((removed = deletablePaths.remove(parentPath)) && this.messages != null && this.messages.isDebugEnabled()) {
                    this.messages.addDebugMessage("Path " + parentPath + " was removed from delete list.").flush();
                }
                parentPath = new File(parentPath).getParent();
            }
        }
        if (!excludedPaths.isEmpty()) {
            boolean removed;
            if (this.messages != null && this.messages.isDebugEnabled()) {
                this.messages.addDebugMessage("Verifying path . is not present; contains file which is excluded.").flush();
            }
            if ((removed = deletablePaths.remove("")) && this.messages != null && this.messages.isDebugEnabled()) {
                this.messages.addDebugMessage("Path . was removed from delete list.").flush();
            }
        }
    }

    private void removeDir(File dir, boolean followSymlinks, boolean throwsError, List warnMessages) throws IOException {
        String[] list = dir.list();
        if (list == null) {
            list = new String[]{};
        }
        for (int i = 0; i < list.length; ++i) {
            String s = list[i];
            File f = new File(dir, s);
            if (f.isDirectory() && (followSymlinks || !this.isSymlink(f))) {
                this.removeDir(f, followSymlinks, throwsError, warnMessages);
                continue;
            }
            if (this.delete(f)) continue;
            String message = "Unable to delete file " + f.getAbsolutePath();
            if (throwsError) {
                throw new IOException(message);
            }
            if (warnMessages.contains(message)) continue;
            warnMessages.add(message);
        }
        if (!this.delete(dir)) {
            String message = "Unable to delete directory " + dir.getAbsolutePath();
            if (throwsError) {
                throw new IOException(message);
            }
            if (!warnMessages.contains(message)) {
                warnMessages.add(message);
            }
        }
    }

    private boolean delete(File f) {
        try {
            FileUtils.forceDelete(f);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private DirectoryScanner scan(FileSet fileSet) {
        File basedir = new File(fileSet.getDirectory());
        if (!basedir.exists() || !basedir.isDirectory()) {
            return null;
        }
        DirectoryScanner scanner = new DirectoryScanner();
        String[] includesArray = fileSet.getIncludesArray();
        String[] excludesArray = fileSet.getExcludesArray();
        if (includesArray.length > 0) {
            scanner.setIncludes(includesArray);
        }
        if (excludesArray.length > 0) {
            scanner.setExcludes(excludesArray);
        }
        if (fileSet.isUseDefaultExcludes()) {
            scanner.addDefaultExcludes();
        }
        scanner.setBasedir(basedir);
        scanner.setFollowSymlinks(fileSet.isFollowSymlinks());
        scanner.scan();
        return scanner;
    }
}

