/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceLoaderUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceLoaderUtils.class);

    private ServiceLoaderUtils() {
        throw new IllegalStateException("Do not instance");
    }

    public static <T> List<T> load(Class<T> type, ClassLoader classLoader) {
        ArrayList<T> loaded = new ArrayList<T>();
        Iterator<T> iterator = ServiceLoader.load(type, classLoader).iterator();
        while (ServiceLoaderUtils.hasNextSafely(iterator)) {
            try {
                T next = iterator.next();
                loaded.add(next);
                LOGGER.debug("Found {}", (Object)type);
            }
            catch (Exception e) {
                LOGGER.error("Could not load {}: {}", (Object)type, (Object)e);
            }
        }
        return loaded;
    }

    private static boolean hasNextSafely(Iterator iterator) {
        try {
            return iterator.hasNext();
        }
        catch (Exception e) {
            LOGGER.error("iterator.hasNext() failed", e);
            return false;
        }
    }
}

