/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.junit4;

import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.Description;
import io.qameta.allure.junit4.DisplayName;
import io.qameta.allure.model.Label;
import io.qameta.allure.model.Link;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.util.AnnotationUtils;
import io.qameta.allure.util.ResultsUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.junit.Ignore;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

@RunListener.ThreadSafe
public class AllureJunit4
extends RunListener {
    private final ThreadLocal<String> testCases = new InheritableThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return UUID.randomUUID().toString();
        }
    };
    private final AllureLifecycle lifecycle;

    public AllureJunit4() {
        this(Allure.getLifecycle());
    }

    public AllureJunit4(AllureLifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public AllureLifecycle getLifecycle() {
        return this.lifecycle;
    }

    @Override
    public void testRunStarted(org.junit.runner.Description description) {
    }

    @Override
    public void testRunFinished(Result result) {
    }

    @Override
    public void testStarted(org.junit.runner.Description description) {
        String uuid = this.testCases.get();
        TestResult result = this.createTestResult(uuid, description);
        this.getLifecycle().scheduleTestCase(result);
        this.getLifecycle().startTestCase(uuid);
    }

    @Override
    public void testFinished(org.junit.runner.Description description) {
        String uuid = this.testCases.get();
        this.testCases.remove();
        this.getLifecycle().updateTestCase(uuid, testResult -> {
            if (Objects.isNull((Object)testResult.getStatus())) {
                testResult.setStatus(Status.PASSED);
            }
        });
        this.getLifecycle().stopTestCase(uuid);
        this.getLifecycle().writeTestCase(uuid);
    }

    @Override
    public void testFailure(Failure failure) {
        String uuid = this.testCases.get();
        this.getLifecycle().updateTestCase(uuid, testResult -> testResult.setStatus(ResultsUtils.getStatus(failure.getException()).orElse(null)).setStatusDetails(ResultsUtils.getStatusDetails(failure.getException()).orElse(null)));
    }

    @Override
    public void testAssumptionFailure(Failure failure) {
        String uuid = this.testCases.get();
        this.getLifecycle().updateTestCase(uuid, testResult -> testResult.setStatus(Status.SKIPPED).setStatusDetails(ResultsUtils.getStatusDetails(failure.getException()).orElse(null)));
    }

    @Override
    public void testIgnored(org.junit.runner.Description description) {
        String uuid = this.testCases.get();
        this.testCases.remove();
        TestResult result = this.createTestResult(uuid, description);
        result.setStatus(Status.SKIPPED);
        result.setStatusDetails(this.getIgnoredMessage(description));
        result.setStart(System.currentTimeMillis());
        this.getLifecycle().scheduleTestCase(result);
        this.getLifecycle().stopTestCase(uuid);
        this.getLifecycle().writeTestCase(uuid);
    }

    private Optional<String> getDisplayName(org.junit.runner.Description result) {
        return Optional.ofNullable(result.getAnnotation(DisplayName.class)).map(DisplayName::value);
    }

    private Optional<String> getDescription(org.junit.runner.Description result) {
        return Optional.ofNullable(result.getAnnotation(Description.class)).map(Description::value);
    }

    private List<Link> extractLinks(org.junit.runner.Description description) {
        ArrayList<Link> result = new ArrayList<Link>(AnnotationUtils.getLinks(description.getAnnotations()));
        Optional.of(description).map(org.junit.runner.Description::getTestClass).map(AnnotationUtils::getLinks).ifPresent(result::addAll);
        return result;
    }

    private List<Label> extractLabels(org.junit.runner.Description description) {
        ArrayList<Label> result = new ArrayList<Label>(AnnotationUtils.getLabels(description.getAnnotations()));
        Optional.of(description).map(org.junit.runner.Description::getTestClass).map(AnnotationUtils::getLabels).ifPresent(result::addAll);
        return result;
    }

    private String getHistoryId(org.junit.runner.Description description) {
        return ResultsUtils.md5(description.getClassName() + description.getMethodName());
    }

    private String getPackage(Class<?> testClass) {
        return Optional.ofNullable(testClass).map(Class::getPackage).map(Package::getName).orElse("");
    }

    private StatusDetails getIgnoredMessage(org.junit.runner.Description description) {
        Ignore ignore = description.getAnnotation(Ignore.class);
        String message = Objects.nonNull(ignore) && !ignore.value().isEmpty() ? ignore.value() : "Test ignored (without reason)!";
        return new StatusDetails().setMessage(message);
    }

    private TestResult createTestResult(String uuid, org.junit.runner.Description description) {
        String className = description.getClassName();
        String methodName = description.getMethodName();
        String name = Objects.nonNull(methodName) ? methodName : className;
        String fullName = Objects.nonNull(methodName) ? String.format("%s.%s", className, methodName) : className;
        String suite = Optional.ofNullable(description.getTestClass()).map(it -> it.getAnnotation(DisplayName.class)).map(DisplayName::value).orElse(className);
        TestResult testResult = new TestResult().setUuid(uuid).setHistoryId(this.getHistoryId(description)).setFullName(fullName).setName(name);
        testResult.getLabels().addAll(ResultsUtils.getProvidedLabels());
        testResult.getLabels().addAll(Arrays.asList(ResultsUtils.createPackageLabel(this.getPackage(description.getTestClass())), ResultsUtils.createTestClassLabel(className), ResultsUtils.createTestMethodLabel(name), ResultsUtils.createSuiteLabel(suite), ResultsUtils.createHostLabel(), ResultsUtils.createThreadLabel(), ResultsUtils.createFrameworkLabel("junit4"), ResultsUtils.createLanguageLabel("java")));
        testResult.getLabels().addAll(this.extractLabels(description));
        testResult.getLinks().addAll(this.extractLinks(description));
        this.getDisplayName(description).ifPresent(testResult::setName);
        this.getDescription(description).ifPresent(testResult::setDescription);
        return testResult;
    }
}

