/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.common.v1.base;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import net.polyv.common.v1.constant.Constant;
import net.polyv.common.v1.exception.PloyvSdkException;
import net.polyv.common.v1.util.StringUtils;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpConnectionFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultHttpResponseParserFactory;
import org.apache.http.impl.conn.ManagedHttpClientConnectionFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;
import org.apache.http.impl.io.DefaultHttpRequestWriterFactory;
import org.apache.http.io.HttpMessageParserFactory;
import org.apache.http.io.HttpMessageWriterFactory;
import org.apache.http.pool.PoolStats;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpClientUtil.class);
    private static PoolingHttpClientConnectionManager manager = null;
    private static CloseableHttpClient httpClient = null;
    private static String proxyHostName = null;
    private static int proxyPort;
    private static String proxyScheme;
    private static int TIME_OUT;
    private static int MAX_CLIENT_NUM;

    public static int getMaxClientNum() {
        return MAX_CLIENT_NUM;
    }

    public static void setMaxClientNum(int maxClientNum) {
        MAX_CLIENT_NUM = maxClientNum < 300 ? maxClientNum : 300;
    }

    public static int getTimeOut() {
        return TIME_OUT;
    }

    public static void setTimeOut(int timeOut) {
        TIME_OUT = timeOut < 30000 ? timeOut : 30000;
    }

    private HttpClientUtil() {
    }

    protected static PoolStats getPoolState() {
        return manager.getTotalStats();
    }

    public static PoolingHttpClientConnectionManager getManager() {
        return manager;
    }

    public static synchronized CloseableHttpClient getHttpClient() {
        if (httpClient == null) {
            String message = "HTTP\u8fde\u63a5\u6c60\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u8c03\u7528\u521d\u59cb\u5316\u65b9\u6cd5";
            PloyvSdkException exception = new PloyvSdkException(Constant.BUSINESS_ERROR_CODE, message);
            log.error(message, (Throwable)exception);
            throw exception;
        }
        return httpClient;
    }

    public static CloseableHttpClient init() {
        return HttpClientUtil.init(null, 0, null);
    }

    public static synchronized CloseableHttpClient init(String hostName, int port, String scheme) {
        if (httpClient == null) {
            log.info("---init HTTP POOL httpClient ----");
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(SSLContexts.createDefault(), new HostnameVerifier(){

                @Override
                public boolean verify(String s, SSLSession sslSession) {
                    if (StringUtils.isBlank(s)) {
                        return false;
                    }
                    return s.equalsIgnoreCase(sslSession.getPeerHost());
                }
            })).build();
            ManagedHttpClientConnectionFactory connectionFactory = new ManagedHttpClientConnectionFactory((HttpMessageWriterFactory)DefaultHttpRequestWriterFactory.INSTANCE, (HttpMessageParserFactory)DefaultHttpResponseParserFactory.INSTANCE);
            SystemDefaultDnsResolver dnsResolver = SystemDefaultDnsResolver.INSTANCE;
            manager = new PoolingHttpClientConnectionManager(socketFactoryRegistry, (HttpConnectionFactory)connectionFactory, (DnsResolver)dnsResolver);
            SocketConfig defaultSocketConfig = SocketConfig.custom().setTcpNoDelay(true).build();
            manager.setDefaultSocketConfig(defaultSocketConfig);
            manager.setMaxTotal(MAX_CLIENT_NUM);
            manager.setDefaultMaxPerRoute(MAX_CLIENT_NUM);
            manager.setValidateAfterInactivity(5000);
            HttpHost proxy = null;
            if (StringUtils.isEmpty(scheme)) {
                scheme = "http";
            }
            if (!StringUtils.isEmpty(hostName)) {
                proxy = new HttpHost(hostName, port, scheme);
                proxyHostName = hostName;
                proxyPort = port;
                proxyScheme = scheme;
            }
            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(TIME_OUT).setSocketTimeout(TIME_OUT).setConnectionRequestTimeout(TIME_OUT).setProxy(proxy).build();
            httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)manager).setConnectionManagerShared(false).evictIdleConnections(30L, TimeUnit.SECONDS).evictExpiredConnections().setConnectionTimeToLive(60L, TimeUnit.SECONDS).setDefaultRequestConfig(defaultRequestConfig).setConnectionReuseStrategy((ConnectionReuseStrategy)DefaultConnectionReuseStrategy.INSTANCE).setKeepAliveStrategy((ConnectionKeepAliveStrategy)DefaultConnectionKeepAliveStrategy.INSTANCE).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false)).build();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        if (httpClient != null) {
                            log.info("-----destroy HTTP POOL httpClient------");
                            httpClient.close();
                        }
                    }
                    catch (IOException e) {
                        log.error("error when close httpClient:{}", (Throwable)e);
                    }
                }
            });
        }
        return httpClient;
    }

    public static String getProxyHostName() {
        return proxyHostName;
    }

    public static int getProxyPort() {
        return proxyPort;
    }

    public static String getProxyScheme() {
        return proxyScheme;
    }

    static {
        TIME_OUT = 20000;
        MAX_CLIENT_NUM = 100;
    }
}

