/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.common.v1.validator.handle;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.polyv.common.v1.exception.PloyvSdkException;
import net.polyv.common.v1.validator.ViolationMsg;
import net.polyv.common.v1.validator.handle.LengthValidator;
import net.polyv.common.v1.validator.handle.MaxValidator;
import net.polyv.common.v1.validator.handle.MinValidator;
import net.polyv.common.v1.validator.handle.NotBlankValidator;
import net.polyv.common.v1.validator.handle.NotEmptyValidator;
import net.polyv.common.v1.validator.handle.NotNullValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Validator {
    private static final Logger log = LoggerFactory.getLogger(Validator.class);
    private Validator nextRequestValidator;
    private boolean fastFail = false;

    public abstract Class getCurrentClass();

    public Validator setFastFail(boolean fastFail) {
        this.fastFail = fastFail;
        return this;
    }

    public void setNextRequestValidator(Validator nextRequestValidator) {
        this.nextRequestValidator = nextRequestValidator;
    }

    public final List<ViolationMsg> validate(Object data, Class<?> ... groups) {
        try {
            groups = groups == null ? new Class[]{} : groups;
            ArrayList<ViolationMsg> violationMsgList = new ArrayList<ViolationMsg>();
            for (Class<?> objClass = data.getClass(); null != objClass; objClass = objClass.getSuperclass()) {
                Field[] fields = objClass.getDeclaredFields();
                block6: for (int i = 0; i < fields.length; ++i) {
                    Annotation[] annotations;
                    Field f = objClass.getDeclaredField(fields[i].getName());
                    f.setAccessible(true);
                    Object o = f.get(data);
                    for (Annotation annotation : annotations = f.getAnnotations()) {
                        violationMsgList.addAll(this.validate(annotation, f, o, groups));
                        if (this.fastFail && !violationMsgList.isEmpty()) continue block6;
                    }
                }
            }
            return violationMsgList;
        }
        catch (NoSuchFieldException e) {
            log.error(e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            log.error(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            log.error(e.getMessage(), e);
        }
        catch (SecurityException e) {
            log.error(e.getMessage(), e);
        }
        return new ArrayList<ViolationMsg>();
    }

    private final List<ViolationMsg> validate(Annotation annotation, Field field, Object data, Class<?> ... groups) {
        ArrayList<ViolationMsg> violationMsgList = new ArrayList<ViolationMsg>();
        Class currentClass = this.getCurrentClass();
        if (null != currentClass && currentClass.equals(annotation.annotationType())) {
            String msg = this.dealValidate(annotation, field, data, groups);
            if (msg != null) {
                ViolationMsg violationMsg = new ViolationMsg();
                violationMsg.setMsg(msg).setFieldData(data).setField(field);
                violationMsgList.add(violationMsg);
            }
            return violationMsgList;
        }
        if (null != this.nextRequestValidator) {
            violationMsgList.addAll(this.nextRequestValidator.validate(annotation, field, data, groups));
        }
        return violationMsgList;
    }

    protected abstract String dealValidate(Annotation var1, Field var2, Object var3, Class<?> ... var4);

    public static Validator getValidator() {
        return Validator.getValidator(null);
    }

    public static Validator getValidator(Class ... clazz) {
        Validator validator;
        if (clazz != null) {
            Map<Class, Validator> validatorMap = Validator.getValidatorMap();
            ArrayList<Validator> validatorList = new ArrayList<Validator>();
            for (Class temp : clazz) {
                Validator tempValidator = validatorMap.get(temp);
                if (tempValidator == null) continue;
                validatorList.add(tempValidator);
            }
            validator = Validator.initValidator(validatorList);
        } else {
            validator = Validator.initValidator(Validator.getValidatorList());
        }
        if (validator == null) {
            throw new PloyvSdkException(500, "\u8bf7\u8bbe\u7f6e\u6b63\u786e\u7684\u6ce8\u89e3class");
        }
        return validator;
    }

    private static Validator initValidator(List<Validator> validatorList) {
        Validator baseValidator = null;
        for (Validator temp : validatorList) {
            if (baseValidator == null) {
                baseValidator = temp;
                continue;
            }
            if (temp == null) continue;
            temp.setNextRequestValidator(baseValidator);
            baseValidator = temp;
        }
        return baseValidator;
    }

    private static Map<Class, Validator> getValidatorMap() {
        HashMap<Class, Validator> validatorMap = new HashMap<Class, Validator>();
        for (Validator validator : Validator.getValidatorList()) {
            validatorMap.put(validator.getCurrentClass(), validator);
        }
        LengthValidator lengthValidator = new LengthValidator();
        validatorMap.put(lengthValidator.getCurrentClass(), lengthValidator);
        return validatorMap;
    }

    private static List<Validator> getValidatorList() {
        List<Validator> list = Arrays.asList(new LengthValidator(), new MinValidator(), new MaxValidator(), new NotBlankValidator(), new NotEmptyValidator(), new NotNullValidator());
        return list;
    }

    protected boolean showMsg(Class<?>[] groups, Class<?>[] groupsAnnotate) {
        if (groups.length > 0) {
            if (groupsAnnotate.length > 0) {
                return this.hasSame(groups, groupsAnnotate);
            }
            return false;
        }
        return true;
    }

    private boolean hasSame(Class<?>[] groupsOne, Class<?>[] groupsTwo) {
        HashSet set = new HashSet(Arrays.asList(groupsOne));
        set.retainAll(Arrays.asList(groupsTwo));
        return set.size() > 0;
    }
}

