/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.common.v1.base;

import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.polyv.common.v1.base.HttpClientUtil;
import net.polyv.common.v1.util.AddressUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    public static final String SOURCE = "source";
    private static String SDK = "SDK";
    public static final String VERSION = "version";
    private static final String CURRENT_VERSION = "1.0.11";
    private static final String UTF8 = "UTF-8";
    private static String APP_ID = "";
    private static String USER_ID = "";
    private static final String IP = AddressUtils.getV4IP();

    public static String getSDK() {
        return SDK;
    }

    public static void setSDK(String SDK) {
        HttpUtil.SDK = SDK;
    }

    public static String getAppId() {
        return APP_ID;
    }

    public static void setAppId(String appId) {
        APP_ID = appId;
    }

    public static String getUserId() {
        return USER_ID;
    }

    public static void setUserId(String userId) {
        USER_ID = userId;
    }

    public static String sendPostDataByMap(String url, String pathVariable, Map<String, String> params, String encoding) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)pathVariable)) {
            url = String.format(url, pathVariable);
        }
        return HttpUtil.sendPostDataByMap(url, params, encoding);
    }

    public static String sendPostDataByMap(String url, Map<String, String> params, String encoding) throws IOException {
        log.debug("http \u8bf7\u6c42 url: {} , \u8bf7\u6c42\u53c2\u6570: {}", (Object)url, (Object)JSON.toJSONString(params));
        if (StringUtils.isBlank((CharSequence)encoding)) {
            encoding = UTF8;
        }
        String result = null;
        CloseableHttpResponse response = null;
        CloseableHttpClient httpClient = HttpClientUtil.getHttpClient();
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader(SOURCE, SDK);
        httpPost.addHeader(VERSION, CURRENT_VERSION);
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                String value = entry.getValue();
                if (value == null) continue;
                nameValuePairs.add(new BasicNameValuePair(entry.getKey(), value));
            }
        }
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, encoding));
        httpPost.setHeader("Content-type", "application/x-www-form-urlencoded; charset=UTF-8");
        httpPost.setHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
        response = HttpUtil.sendRequestAndGetResult(url, httpClient, (HttpUriRequest)httpPost);
        if (null != response) {
            result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)encoding);
            log.debug("http \u8bf7\u6c42\u7ed3\u679c: {}", (Object)result);
        }
        try {
            if (null != response) {
                response.close();
            }
        }
        catch (IOException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    public static String sendPostDataByJson(String url, String pathVariable, Map<String, String> params, String encoding) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)pathVariable)) {
            url = String.format(url, pathVariable);
        }
        return HttpUtil.sendPostDataByJson(url, JSON.toJSONString(params), encoding);
    }

    public static String sendPostDataByJson(String url, Map<String, String> params, String encoding) throws IOException {
        return HttpUtil.sendPostDataByJson(url, JSON.toJSONString(params), encoding);
    }

    public static String sendPostDataByJson(String url, String pathVariable, String json, String encoding) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)pathVariable)) {
            url = String.format(url, pathVariable);
        }
        return HttpUtil.sendPostDataByJson(url, json, encoding);
    }

    public static String sendPostDataByJson(String url, String json, String encoding) throws IOException {
        log.debug("http \u8bf7\u6c42 url: {} , \u8bf7\u6c42\u53c2\u6570: {}", (Object)url, (Object)json);
        if (StringUtils.isBlank((CharSequence)encoding)) {
            encoding = UTF8;
        }
        String result = null;
        CloseableHttpClient httpClient = HttpClientUtil.getHttpClient();
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader(SOURCE, SDK);
        httpPost.addHeader(VERSION, CURRENT_VERSION);
        StringEntity stringEntity = new StringEntity(json, ContentType.APPLICATION_JSON);
        stringEntity.setContentEncoding(encoding);
        httpPost.setEntity((HttpEntity)stringEntity);
        CloseableHttpResponse response = HttpUtil.sendRequestAndGetResult(url, httpClient, (HttpUriRequest)httpPost);
        if (null != response) {
            result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)encoding);
            log.debug("http \u8bf7\u6c42\u7ed3\u679c: {}", (Object)result);
        }
        try {
            if (null != response) {
                response.close();
            }
        }
        catch (IOException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    public static String sendGetData(String url, String pathVariable, String encoding) throws IOException {
        return HttpUtil.sendGetData(url, pathVariable, null, encoding);
    }

    public static String sendGetData(String url, Map<String, Object> params, String encoding) throws IOException {
        return HttpUtil.sendGetData(url, null, params, encoding);
    }

    public static String sendGetData(String url, String pathVariable, Map<String, Object> params, String encoding) throws IOException {
        String paramStr;
        if (StringUtils.isNotBlank((CharSequence)pathVariable)) {
            url = String.format(url, pathVariable);
        }
        StringBuilder paramStringBuffer = new StringBuilder();
        if (null != params) {
            for (Map.Entry<String, Object> next : params.entrySet()) {
                paramStringBuffer.append(next.getKey()).append("=").append(next.getValue()).append("&");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(paramStr = paramStringBuffer.toString()))) {
            url = url + "?" + paramStr.substring(0, paramStr.length() - 1);
        }
        return HttpUtil.sendGetData(url, encoding);
    }

    public static String sendGetData(String url, String encoding) throws IOException {
        return HttpUtil.commonSendGetData(url, encoding, new DataParse<String>(){

            @Override
            public String parseData(HttpEntity httpEntity, String encoding) throws IOException {
                return EntityUtils.toString((HttpEntity)httpEntity, (String)encoding);
            }
        });
    }

    public static byte[] sendGetDataReturnArray(String url, String encoding) throws IOException {
        return HttpUtil.commonSendGetData(url, encoding, new DataParse<byte[]>(){

            @Override
            public byte[] parseData(HttpEntity httpEntity, String encoding) throws IOException {
                return EntityUtils.toByteArray((HttpEntity)httpEntity);
            }
        });
    }

    private static <T> T commonSendGetData(String url, String encoding, DataParse<T> dataParse) throws IOException {
        log.debug("http \u8bf7\u6c42 url: {}", (Object)url);
        if (StringUtils.isBlank((CharSequence)encoding)) {
            encoding = UTF8;
        }
        T result = null;
        CloseableHttpClient httpClient = HttpClientUtil.getHttpClient();
        HttpGet httpGet = new HttpGet(url);
        httpGet.addHeader(SOURCE, SDK);
        httpGet.addHeader(VERSION, CURRENT_VERSION);
        httpGet.addHeader("Content-type", "application/json; charset=UTF-8");
        CloseableHttpResponse response = HttpUtil.sendRequestAndGetResult(url, httpClient, (HttpUriRequest)httpGet);
        if (null != response && !((result = (T)dataParse.parseData(response.getEntity(), encoding)) instanceof byte[])) {
            log.debug("http \u8bf7\u6c42\u7ed3\u679c: {}", result);
        }
        try {
            if (null != response) {
                response.close();
            }
        }
        catch (IOException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    private static CloseableHttpResponse sendRequestAndGetResult(String url, CloseableHttpClient httpClient, HttpUriRequest httpUriRequest) throws IOException {
        long startTime = System.currentTimeMillis();
        CloseableHttpResponse response = httpClient.execute(httpUriRequest);
        long endTime = System.currentTimeMillis();
        HttpUtil.collectAPISpendTime(url, startTime, endTime);
        return response;
    }

    private static void collectAPISpendTime(String url, long startTime, long endTime) {
        log.debug("HTTP\u8bf7\u6c42\u8017\u65f6\u5206\u6790\uff0c\u8bf7\u6c42URL: {} \uff0c userId: {} \uff0c appId: {} \uff0c sdk\u7248\u672c: {} \uff0c IP: {} \uff0c \u8017\u65f6: {} ms", new Object[]{url, HttpUtil.getUserId(), HttpUtil.getAppId(), CURRENT_VERSION, IP, endTime - startTime});
    }

    public static String sendUploadFile(String url, Map<String, String> params, Map<String, File> fileMap, String encoding) throws IOException {
        log.debug("http \u8bf7\u6c42 url: {} , \u8bf7\u6c42\u53c2\u6570: {}", (Object)url, (Object)JSON.toJSONString(params));
        if (StringUtils.isBlank((CharSequence)encoding)) {
            encoding = UTF8;
        }
        String result = null;
        CloseableHttpClient httpClient = HttpClientUtil.getHttpClient();
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader(SOURCE, SDK);
        httpPost.addHeader(VERSION, CURRENT_VERSION);
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        if (fileMap != null) {
            for (Map.Entry<String, File> entry : fileMap.entrySet()) {
                File file = entry.getValue();
                entityBuilder.addBinaryBody(entry.getKey(), file);
            }
        }
        ContentType contentType = ContentType.create((String)"text/plain", (Charset)Charset.forName(encoding));
        if (null != params) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                entityBuilder.addTextBody(entry.getKey(), entry.getValue(), contentType);
            }
        }
        HttpEntity httpEntity = entityBuilder.build();
        httpPost.setEntity(httpEntity);
        CloseableHttpResponse closeableHttpResponse = HttpUtil.sendRequestAndGetResult(url, httpClient, (HttpUriRequest)httpPost);
        if (null != closeableHttpResponse) {
            result = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity(), (String)encoding);
            log.debug("http \u8bf7\u6c42\u7ed3\u679c: {}", (Object)result);
        }
        try {
            if (null != closeableHttpResponse) {
                closeableHttpResponse.close();
            }
        }
        catch (IOException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    public static String sendUploadFileList(String url, Map<String, String> params, Map<String, List<File>> fileListMap, String encoding) throws IOException {
        log.debug("http \u8bf7\u6c42 url: {} , \u8bf7\u6c42\u53c2\u6570: {}", (Object)url, (Object)JSON.toJSONString(params));
        if (StringUtils.isBlank((CharSequence)encoding)) {
            encoding = UTF8;
        }
        String result = null;
        CloseableHttpClient httpClient = HttpClientUtil.getHttpClient();
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader(SOURCE, SDK);
        httpPost.addHeader(VERSION, CURRENT_VERSION);
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        ContentType contentType = ContentType.create((String)"text/plain", (Charset)Charset.forName(encoding));
        if (null != params) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                entityBuilder.addTextBody(entry.getKey(), (String)entry.getValue(), contentType);
            }
        }
        if (fileListMap != null) {
            for (Map.Entry<String, Object> entry : fileListMap.entrySet()) {
                String key = entry.getKey();
                List fileList = (List)entry.getValue();
                for (File file : fileList) {
                    FileBody fileBody = new FileBody(file);
                    entityBuilder.addPart(key, (ContentBody)fileBody);
                }
            }
        }
        HttpEntity entity = entityBuilder.build();
        httpPost.setEntity(entity);
        CloseableHttpResponse closeableHttpResponse = HttpUtil.sendRequestAndGetResult(url, httpClient, (HttpUriRequest)httpPost);
        if (null != closeableHttpResponse) {
            result = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity(), (String)encoding);
            log.debug("http \u8bf7\u6c42\u7ed3\u679c: {}", (Object)result);
        }
        try {
            if (null != closeableHttpResponse) {
                closeableHttpResponse.close();
            }
        }
        catch (IOException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    static interface DataParse<T> {
        public T parseData(HttpEntity var1, String var2) throws IOException;
    }
}

