package net.polyv.live.v2.entity.user.template;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 修改默认模板防录屏设置请求实体
 * @author liyongxuan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("修改默认模板防录屏设置请求实体")
public class LiveUpdateMarqueeRequest extends LiveCommonRequest {
    /**
     * 防录屏开关 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "enable", value = "防录屏开关 Y：开启 N：关闭", required = true)
    @NotNull(message = "属性enable不能为空")
    private String enable;
    
    /**
     * 防录屏方式，防录屏开关开启时必填 marquee：跑马灯 watermark：水印
     */
    @ApiModelProperty(name = "antiRecordType", value = "防录屏方式，防录屏开关开启时必填 marquee：跑马灯 watermark：水印", required = false)
    private String antiRecordType;
    
    /**
     * 防录屏类型，防录屏开关开启时必填，水印方式时设置自定义URL无效 fixed：固定 nickname：用户名 diyurl：url自定义设置，仅跑马灯方式有效
     */
    @ApiModelProperty(name = "modelType", value = "防录屏类型，防录屏开关开启时必填，水印方式时设置自定义URL无效 fixed：固定 nickname：用户名 " +
            "diyurl：url自定义设置，仅跑马灯方式有效", required = false)
    private String modelType;
    
    /**
     * 防录屏类型是固定值时为设置内容 URL自定义设置时为网址，需要携带 http:// 或 https:// 防录屏类型为登录用户名时可不传，固定值和url自定义设置时必传
     */
    @ApiModelProperty(name = "content", value = "防录屏类型是固定值时为设置内容 URL自定义设置时为网址，需要携带 http:// 或 https:// " +
            "防录屏类型为登录用户名时可不传，固定值和url自定义设置时必传", required = false)
    private String content;
    
    /**
     * 跑马灯透明度，范围0-99 水印透明度，范围0-100
     */
    @ApiModelProperty(name = "opacity", value = "跑马灯透明度，范围0-99 水印透明度，范围0-100", required = false)
    private Integer opacity;
    
    /**
     * 字体大小 防录屏方式为跑马灯时：设置数值，范围1-256 防录屏方式为水印时： small：小 middle：中 large：大
     */
    @ApiModelProperty(name = "fontSize", value = "字体大小 防录屏方式为跑马灯时：设置数值，范围1-256 防录屏方式为水印时： small：小 middle：中 large：大",
            required = false)
    private String fontSize;
    
    /**
     * 跑马灯字体颜色，色值，例如：#FFFFFF
     */
    @ApiModelProperty(name = "fontColor", value = "跑马灯字体颜色，色值，例如：#FFFFFF", required = false)
    private String fontColor;
    
    /**
     * 跑马灯显示方式 roll：滚动 flicker：闪烁
     */
    @ApiModelProperty(name = "showMode", value = "跑马灯显示方式 roll：滚动 flicker：闪烁", required = false)
    private String showMode;
    
    /**
     * 双跑马灯开关 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "doubleEnabled", value = "双跑马灯开关 Y：开启 N：关闭", required = false)
    private String doubleEnabled;
    
    /**
     * 自定义缩放开关 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "autoZoomEnabled", value = "自定义缩放开关 Y：开启 N：关闭", required = false)
    private String autoZoomEnabled;
    
}