package net.polyv.live.v2.entity.chat;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 账号设置禁言/解禁用户请求实体
 * @author liyongxuan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("账号设置禁言/解禁用户请求实体")
public class LiveUpdateUserBannedViewerRequest extends LiveCommonRequest {
    /**
     * 聊天室用户ID（非直播账号ID），json数组格式
     */
    @ApiModelProperty(name = "viewerIds", value = "聊天室用户ID（非直播账号ID），json数组格式", required = true)
    @NotNull(message = "属性viewerIds不能为空")
    private List<String> viewerIds;
    
    /**
     * Y表示禁言，N表示解除禁言
     */
    @ApiModelProperty(name = "banned", value = "Y表示禁言，N表示解除禁言", required = true)
    @NotNull(message = "属性banned不能为空")
    private String banned;
    
}