package net.polyv.live.v2.entity.chat;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 禁言/解禁用户请求实体
 * @author liyongxuan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("禁言/解禁用户请求实体")
public class LiveUpdateBannedUserRequest extends LiveCommonRequest {
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 聊天室用户ID（非直播账号ID），多个用户用半角逗号","隔开。
     */
    @ApiModelProperty(name = "userIds", value = "聊天室用户ID（非直播账号ID），多个用户用半角逗号\",\"隔开。", required = true)
    @NotNull(message = "属性userIds不能为空")
    private String userIds;
    
    /**
     * Y表示禁言，N表示解除禁言
     */
    @ApiModelProperty(name = "toBanned", value = "Y表示禁言，N表示解除禁言", required = false)
    private String toBanned;
    
}