package net.polyv.live.v2.entity.chat;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 删除账号严禁词请求实体
 * @author liyongxuan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("删除账号严禁词请求实体")
public class LiveDeleteUserBadwordRequest extends LiveCommonRequest {
    /**
     * 要删除的严禁词，多个以英文逗号分隔，例如：账号严禁词1,账号严禁词2
     */
    @ApiModelProperty(name = "words", value = "要删除的严禁词，多个以英文逗号分隔，例如：账号严禁词1,账号严禁词2", required = true)
    @NotNull(message = "属性words不能为空")
    private String words;
    
}