package net.polyv.live.v2.entity.channel.web.interact.cardpush;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 修改频道卡片推送请求实体
 * @author jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("修改频道卡片推送请求实体")
public class LiveUpdateChannelCardPushRequest extends LiveCommonRequest {
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 卡片推送主键ID
     */
    @ApiModelProperty(name = "cardPushId", value = "卡片推送主键ID", required = true)
    @NotNull(message = "属性cardPushId不能为空")
    private Long cardPushId;
    
    /**
     * 卡片样式类型，giftbox：礼物领取样式，redpack：红包样式
     */
    @ApiModelProperty(name = "imageType", value = "卡片样式类型，giftbox：礼物领取样式，redpack：红包样式", required = false)
    private String imageType;
    
    /**
     * 卡片标题，最多16个字符
     */
    @ApiModelProperty(name = "title", value = "卡片标题，最多16个字符", required = false)
    private String title;
    
    /**
     * 卡片跳转链接地址，需要带http:等协议头
     */
    @ApiModelProperty(name = "link", value = "卡片跳转链接地址，需要带http:等协议头", required = false)
    private String link;
    
    /**
     * 卡片倒计时时长，取值：0,5,10,20,30，单位：秒，0为不显示倒计时时长
     */
    @ApiModelProperty(name = "duration", value = "卡片倒计时时长，取值：0,5,10,20,30，单位：秒，0为不显示倒计时时长", required = false)
    private Integer duration;
    
    /**
     * 弹出方式，PUSH：推送后立即弹出、WATCH：观看后弹出
     */
    @ApiModelProperty(name = "showCondition", value = "弹出方式，PUSH：推送后立即弹出、WATCH：观看后弹出", required = false)
    private String showCondition;
    
    /**
     * 观看后弹出的观看时长，showCondition为WATCH时生效
     */
    @ApiModelProperty(name = "conditionValue", value = "观看后弹出的观看时长，showCondition为WATCH时生效", required = false)
    private Integer conditionValue;
    
    /**
     * 观看后弹出的观看时长单位SECONDS.秒、MINUTES.分钟，showCondition为WATCH时，该值生效且必填
     */
    @ApiModelProperty(name = "conditionUnit", value = "观看后弹出的观看时长单位SECONDS.秒、MINUTES.分钟，showCondition为WATCH时，该值生效且必填"
            , required = false)
    private String conditionUnit;
    
    /**
     * 倒计时文案，showCondition为WATCH时生效，最多8个字符
     */
    @ApiModelProperty(name = "countdownMsg", value = "倒计时文案，showCondition为WATCH时生效，最多8个字符", required = false)
    private String countdownMsg;
    
    /**
     * 卡片入口开关Y.开启、N.关闭
     */
    @ApiModelProperty(name = "enterEnabled", value = "卡片入口开关Y.开启、N.关闭", required = false)
    private String enterEnabled;
    
}