package net.polyv.live.v2.entity.channel.viewdata;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.live.v1.entity.LivePageNumberCommonRequest;

/**
 * 查询时间内直播场次数据请求实体
 * @author jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询时间内直播场次数据请求实体")
public class LiveGetLiveSessionRequest extends LivePageNumberCommonRequest {
    /**
     * 开始时间
     */
    @ApiModelProperty(name = "startTime", value = "开始时间", required = false)
    private Date startTime;
    
    /**
     * 结束时间
     */
    @ApiModelProperty(name = "endTime", value = "结束时间", required = false)
    private Date endTime;
}