package net.polyv.live.v2.entity.channel.state;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 批量查询频道直播状态请求实体
 * @author jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("批量查询频道直播状态请求实体")
public class LiveListChannelStreamStatusV2Request extends LiveCommonRequest {
    /**
     * 用英文逗号隔开的频道号，如：10000,100001 最多20个
     */
    @ApiModelProperty(name = "channelIds", value = "用英文逗号隔开的频道号，如：10000,100001 最多20个", required = true)
    @NotNull(message = "属性channelIds不能为空")
    private String channelIds;
    
}