package net.polyv.live.v2.entity.channel.state;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 批量查询频道直播流信息响应实体
 * @author liyongxuan
 */
@Data
@Accessors(chain = true)
@ApiModel("批量查询频道直播流信息响应实体")
public class LiveGetStreamsResponse {
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = false)
    private String channelId;
    
    /**
     * 频道是否直播中 true：直播中 false：未直播
     */
    @ApiModelProperty(name = "live", value = "频道是否直播中 true：直播中 false：未直播", required = false)
    private Boolean live;
    
    /**
     * 频道推流信息，直播中才有值，未直播时为null
     */
    @ApiModelProperty(name = "streamInfo", value = "频道推流信息，直播中才有值，未直播时为null", required = false)
    private List<LiveGetStreamsResponse.StreamInfo> streamInfo;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("频道推流信息，直播中才有值，未直播时为null")
    public static class StreamInfo {
        /**
         * 推送的CDN节点IP地址
         */
        @ApiModelProperty(name = "deployAddress", value = "推送的CDN节点IP地址", required = false)
        private String deployAddress;
        
        /**
         * 推流出口IP地址
         */
        @ApiModelProperty(name = "inAddress", value = "推流出口IP地址", required = false)
        private String inAddress;
        
        /**
         * 流名
         */
        @ApiModelProperty(name = "streamName", value = "流名", required = false)
        private String streamName;
        
        /**
         * 推流帧率
         */
        @ApiModelProperty(name = "fps", value = "推流帧率", required = false)
        private String fps;
        
        /**
         * 推流丢帧率
         */
        @ApiModelProperty(name = "lfr", value = "推流丢帧率", required = false)
        private String lfr;
        
        /**
         * 推流码率，单位：bps
         */
        @ApiModelProperty(name = "inBandWidth", value = "推流码率，单位：bps", required = false)
        private String inBandWidth;
    }
    
}