package net.polyv.live.v2.entity.channel.playback;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 查询频道回放设置响应实体
 * @author liyongxuan
 */
@Data
@Accessors(chain = true)
@ApiModel("查询频道回放设置响应实体")
public class LiveGetPlaybackSettingResponse {
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = false)
    private String channelId;
    
    /**
     * 回放类型 single：单个视频回放 list：列表回放
     */
    @ApiModelProperty(name = "type", value = "回放类型 single：单个视频回放 list：列表回放", required = false)
    private String type;
    
    /**
     * 回放的开关 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "playbackEnabled", value = "回放的开关 Y：开启 N：关闭", required = false)
    private String playbackEnabled;
    
    /**
     * 回放的视频来源 record：录制文件 playback：回放列表 vod：点播列表
     */
    @ApiModelProperty(name = "origin", value = "回放的视频来源 record：录制文件 playback：回放列表 vod：点播列表", required = false)
    private String origin;
    
    /**
     * 回放的视频ID
     */
    @ApiModelProperty(name = "videoId", value = "回放的视频ID", required = false)
    private String videoId;
    
    /**
     * 回放的视频名称
     */
    @ApiModelProperty(name = "videoName", value = "回放的视频名称", required = false)
    private String videoName;
    
    /**
     * 回放设置，章节开关 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "sectionEnabled", value = "回放设置，章节开关 Y：开启 N：关闭", required = false)
    private String sectionEnabled;
    
    /**
     * 是否应用通用设置 Y：是 N：否
     */
    @ApiModelProperty(name = "globalSettingEnabled", value = "是否应用通用设置 Y：是 N：否", required = false)
    private String globalSettingEnabled;
    
    /**
     * 聊天重放 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "chatPlaybackEnabled", value = "聊天重放 Y：开启 N：关闭", required = false)
    private String chatPlaybackEnabled;
    
}