package net.polyv.live.v2.entity.channel.operate;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 创建MR频道响应实体
 * @author jiangyifan
 */
@Data
@Accessors(chain = true)
@ApiModel("创建MR频道响应实体")
public class LiveCreateMrChannelResponse {
    
    /**
     * 频道ID
     */
    @ApiModelProperty(name = "channelId", value = "频道ID", required = false)
    private String channelId;
    
    /**
     * 频道名称
     */
    @ApiModelProperty(name = "name", value = "频道名称", required = false)
    private String name;
    
    /**
     * 直播账号userId
     */
    @ApiModelProperty(name = "userId", value = "直播账号userId", required = false)
    private String userId;
    
    /**
     * MR直播-控制台登录密码
     */
    @ApiModelProperty(name = "channelPasswd", value = "MR直播-控制台登录密码", required = false)
    private String channelPasswd;
    
    /**
     * MR直播-直播助理账号
     */
    @ApiModelProperty(name = "assistantAccount", value = "MR直播-直播助理账号", required = false)
    private String assistantAccount;
    
    /**
     * MR直播-直播助理登录密码
     */
    @ApiModelProperty(name = "assistantPasswd", value = "MR直播-直播助理登录密码", required = false)
    private String assistantPasswd;
    
}