package net.polyv.live.v2.entity.channel.operate;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.Length;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 创建MR频道请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("创建MR频道请求实体")
public class LiveCreateMrChannelRequest extends LiveCommonRequest {
    
    /**
     * 直播名称，最大长度100
     */
    @ApiModelProperty(name = "name", value = "直播名称，最大长度100", required = true)
    @NotNull(message = "属性name不能为空")
    private String name;
    
    /**
     * 分类ID
     */
    @ApiModelProperty(name = "categoryId", value = "分类ID", required = false)
    private Integer categoryId;
    
    /**
     * 开始时间，13位毫秒级时间戳
     */
    @ApiModelProperty(name = "startTime", value = "开始时间，13位毫秒级时间戳", required = false)
    private Date startTime;
    
    /**
     * MR控制台密码，长度6-16位，不传则由系统随机生成
     */
    @ApiModelProperty(name = "channelPasswd", value = "MR控制台密码，长度6-16位，不传则由系统随机生成", required = false)
    @Length(max = 16, message = "控制台密码不能超过16位")
    private String channelPasswd;
    
    /**
     * MR直播助理角色密码，长度6-16位，不传则由系统随机生成
     */
    @ApiModelProperty(name = "assistantPasswd", value = "MR直播助理角色密码，长度6-16位，不传则由系统随机生成", required = false)
    @Length(max = 16, message = "角色密码不能超过16位")
    private String assistantPasswd;
    
    /**
     * 引导页图片地址，非保利威域名下的图片需先调用[上传图片资源](/live/java/webSetting?id=_2、上传图片资源)上传
     */
    @ApiModelProperty(name = "splashImg", value = "引导页图片地址，非保利威域名下的图片需先调用[上传图片资源](/live/java/webSetting?id=_2、上传图片资源)上传", required = false)
    private String splashImg;
    
    /**
     * 子帐号邮箱，提交后，该频道帐号在后台拥有的权限会跟随该子帐号的频道权限
     */
    @ApiModelProperty(name = "subAccount", value = "子帐号邮箱，提交后，该频道帐号在后台拥有的权限会跟随该子帐号的频道权限", required = false)
    private String subAccount;
    
}