package net.polyv.live.v1.entity.chat;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 更新聊天审核开关请求实体
 * @author sadboy
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("更新聊天审核开关请求实体")
public class LiveUpdateChatCensorRequest extends LiveCommonRequest {
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 开关 Y/N, 不传时切换当前开关值
     */
    @ApiModelProperty(name = "enabled", value = "开关 Y/N, */", required = false)
    private String enabled;
    
}
