package net.polyv.live.v1.entity.channel.advanced;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 修改实时字幕语言类型枚举请求实体
 * @author sadboy
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("修改实时字幕语言类型枚举请求实体")
public class LiveUpdateChannelRealtimeSubtitleRequest extends LiveCommonRequest {
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 实时字幕开关，Y：开启，N：关闭
     */
    @ApiModelProperty(name = "realTimeSubtitleEnabled", value = "实时字幕开关，Y：开启，N：关闭", required = false)
    private String realTimeSubtitleEnabled;
    
    /**
     * 原声字幕语种，Chinese：中文；English：英文
     */
    @ApiModelProperty(name = "sourceLanguage", value = "原声字幕语种，Chinese：中文；English：英文", required = false)
    private String sourceLanguage;
    
    /**
     * 字幕翻译开关，Y：开启，N：关闭
     */
    @ApiModelProperty(name = "subtitleTranslationEnabled", value = "字幕翻译开关，Y：开启，N：关闭", required = false)
    private String subtitleTranslationEnabled;
    
    /**
     * 字幕翻译语种，Chinese：中文；English：英文 等，可通过 new LiveChannelAdvancedServiceImpl().getLanguage() 查询
     */
    @ApiModelProperty(name = "translationLanguage", value = "字幕翻译语种，Chinese：中文；English：英文 等，可通过 new LiveChannelAdvancedServiceImpl().getLanguage() 查询", required = false)
    private String translationLanguage;
    
    /**
     * 实时字幕显示数量限制开关，Y：开启，N：关闭
     */
    @ApiModelProperty(name = "realTimeSubtitleDisplayNumberLimitEnabled", value = "实时字幕显示数量限制开关，Y：开启，N：关闭", required = false)
    private String realTimeSubtitleDisplayNumberLimitEnabled;
    
    /**
     * 实时字幕最多显示数量，不能小于5，不能大于20，建议传 5、10或20
     */
    @ApiModelProperty(name = "realTimeSubtitleDisplayNumber", value = "实时字幕最多显示数量，不能小于5，不能大于20，建议传 5、10或20", required = false)
    private Integer realTimeSubtitleDisplayNumber;

}
