package net.polyv.live.v2.entity.user.template;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 查询默认模板防录屏设置响应实体
 * @author liyongxuan
 */
@Data
@Accessors(chain = true)
@ApiModel("查询默认模板防录屏设置响应实体")
public class LiveGetMarqueeResponse {
    
    /**
     * 防录屏开关 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "enable", value = "防录屏开关 Y：开启 N：关闭", required = false)
    private String enable;
    
    /**
     * 防录屏方式 marquee：跑马灯 watermark：水印
     */
    @ApiModelProperty(name = "antiRecordType", value = "防录屏方式 marquee：跑马灯 watermark：水印", required = false)
    private String antiRecordType;
    
    /**
     * 防录屏类型 fixed：固定 nickname：用户名 diyurl：url自定义设置
     */
    @ApiModelProperty(name = "modelType", value = "防录屏类型 fixed：固定 nickname：用户名 diyurl：url自定义设置", required = false)
    private String modelType;
    
    /**
     * 自定义缩放开关 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "autoZoomEnabled", value = "自定义缩放开关 Y：开启 N：关闭", required = false)
    private String autoZoomEnabled;
    
    /**
     * 固定值时为设置内容 URL自定义设置时为网址
     */
    @ApiModelProperty(name = "content", value = "固定值时为设置内容 URL自定义设置时为网址", required = false)
    private String content;
    
    /**
     * 透明度 跑马灯透明度，范围0-99 水印透明度，范围0-100
     */
    @ApiModelProperty(name = "opacity", value = "透明度 跑马灯透明度，范围0-99 水印透明度，范围0-100", required = false)
    private Integer opacity;
    
    /**
     * 双跑马灯开关 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "doubleEnabled", value = "双跑马灯开关 Y：开启 N：关闭", required = false)
    private String doubleEnabled;
    
    /**
     * 跑马灯字体颜色，色值，例如：#FFFFFF
     */
    @ApiModelProperty(name = "fontColor", value = "跑马灯字体颜色，色值，例如：#FFFFFF", required = false)
    private String fontColor;
    
    /**
     * 字体大小 防录屏方式为跑马灯时：设置数值，范围1-256 防录屏方式为水印时： small：小 middle：中 large：大
     */
    @ApiModelProperty(name = "fontSize", value = "字体大小 防录屏方式为跑马灯时：设置数值，范围1-256 防录屏方式为水印时： small：小 middle：中 large：大",
            required = false)
    private String fontSize;
    
    /**
     * 跑马灯显示方式 roll：滚动 flicker：闪烁
     */
    @ApiModelProperty(name = "showMode", value = "跑马灯显示方式 roll：滚动 flicker：闪烁", required = false)
    private String showMode;
    
}