package net.polyv.live.v2.entity.chat;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotBlank;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 发送自定义消息请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("发送自定义消息请求实体")
public class LiveSendCustomMessageRequest extends LiveCommonRequest {
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotBlank(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 发送文字内容
     */
    @ApiModelProperty(name = "content", value = "发送文字内容", required = false)
    private String content;
    
    /**
     * 发送的图片url地址
     */
    @ApiModelProperty(name = "imgUrl", value = "发送的图片url地址", required = false)
    private String imgUrl;
    
    /**
     * 是否加入聊天历史数据，默认为1 1：加入到聊天历史数据 0：不加入
     */
    @ApiModelProperty(name = "joinHistoryList", value = "是否加入聊天历史数据，默认为1 1：加入到聊天历史数据 0：不加入", required = false)
    private Integer joinHistoryList;
    
    /**
     * 此消息面向何种角色发送（默认为1，支持多选，如：45）<br/> 1：面向频道所有角色<br/>2：仅面向频道内观众角色<br/>3：仅面向特殊角色（讲师、嘉宾、助教、管理员）<br/>4：讲师<br/>5：嘉宾<br/>6：助教<br/> 7：管理员
     */
    @ApiModelProperty(name = "watchType", value = "此消息面向何种角色发送（默认为1，支持多选，如：45）<br/> 1：面向频道所有角色<br/>2：仅面向频道内观众角色<br/>3：仅面向特殊角色（讲师、嘉宾、助教、管理员）<br/>4：讲师<br/>5：嘉宾<br/>6：助教<br/> 7：管理员"
            , required = false)
    private Integer watchType;
    
}