package net.polyv.live.v2.entity.channel.web.interact;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 创建邀请者请求实体
 * @author liyongxuan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("创建邀请者请求实体")
public class LiveCreateInviterRequest extends LiveCommonRequest {
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 邀请者用户ID
     */
    @ApiModelProperty(name = "openId", value = "邀请者用户ID", required = true)
    @NotNull(message = "属性openId不能为空")
    private String openId;
    
    /**
     * 邀请者昵称
     */
    @ApiModelProperty(name = "nickname", value = "邀请者昵称", required = true)
    @NotNull(message = "属性nickname不能为空")
    private String nickname;
    
    /**
     * 邀请者头像url地址，如果为空，则使用默认头像
     */
    @ApiModelProperty(name = "avatar", value = "邀请者头像url地址，如果为空，则使用默认头像", required = false)
    private String avatar;
    
    /**
     * 邀请者观众ID
     */
    @ApiModelProperty(name = "viewerId", value = "邀请者观众ID", required = false)
    private String viewerId;
    
    /**
     * 自定义邀请ID
     */
    @ApiModelProperty(name = "invitee", value = "自定义邀请ID", required = false)
    private String invitee;
    
}