package net.polyv.live.v2.entity.channel.session;

import java.util.Date;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 查询频道场次信息请求实体
 * @author liyongxuan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询频道场次信息请求实体")
public class LiveSessionListRequest extends LiveCommonRequest {
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 直播场次的开始日期，格式：yyyy-MM-dd HH:mm:ss，如果时间为00:00:00也支持格式：yyyy-MM-dd
     */
    @ApiModelProperty(name = "startDate", value = "直播场次的开始日期，格式：yyyy-MM-dd HH:mm:ss，如果时间为00:00:00也支持格式：yyyy-MM-dd",
            required = false)
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date startDate;
    
    /**
     * 直播场次的结束日期，格式：yyyy-MM-dd HH:mm:ss，如果时间为00:00:00也支持格式：yyyy-MM-dd
     */
    @ApiModelProperty(name = "endDate", value = "直播场次的结束日期，格式：yyyy-MM-dd HH:mm:ss，如果时间为00:00:00也支持格式：yyyy-MM-dd",
            required = false)
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;
    
    /**
     * 页数，默认为1
     */
    @ApiModelProperty(name = "page", value = "页数，默认为1", required = false)
    private String page;
    
    /**
     * 每页显示的数据条数，默认20
     */
    @ApiModelProperty(name = "pageSize", value = "每页显示的数据条数，默认20", required = false)
    private String pageSize;
    
}