package net.polyv.live.v2.entity.channel.player;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 查询投诉反馈请求实体
 * @author liyongxuan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询投诉反馈请求实体")
public class LiveGetWatchFeedbackListRequest extends LiveCommonRequest {
    /**
     * 频道号，不传则查询用户下的数据
     */
    @ApiModelProperty(name = "channelId", value = "频道号，不传则查询用户下的数据", required = false)
    private String channelId;
    
    /**
     * 分页页码，默认1
     */
    @ApiModelProperty(name = "pageNumber", value = "分页页码，默认1", required = false)
    private Integer pageNumber;
    
    /**
     * 分页大小，默认10，最大不超过1000
     */
    @ApiModelProperty(name = "pageSize", value = "分页大小，默认10，最大不超过1000", required = false)
    private Integer pageSize;
    
}