package net.polyv.live.v2.entity.channel.account;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 查询所有频道的回放视频请求实体
 * @author liyongxuan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询所有频道的回放视频请求实体")
public class LiveListUserPlaybackRequest extends LiveCommonRequest {
    /**
     * 频道号，不传查询账号下所有回放视频
     */
    @ApiModelProperty(name = "channelId", value = "频道号，不传查询账号下所有回放视频", required = false)
    private String channelId;
    
    /**
     * 页码，默认为1
     */
    @ApiModelProperty(name = "page", value = "页码，默认为1", required = false)
    private String page;
    
    /**
     * 每页数据大小，默认为20，合法范围为1-1000
     */
    @ApiModelProperty(name = "pageSize", value = "每页数据大小，默认为20，合法范围为1-1000", required = false)
    private String pageSize;
    
    /**
     * 排序规则，取值 timeDesc：按createdTime降序 rankDesc：按rank降序 time：按createdTime升序 rank：按rank升序，默认是timeDesc
     */
    @ApiModelProperty(name = "order", value = "排序规则，取值 timeDesc：按createdTime降序 rankDesc：按rank降序 time：按createdTime升序 " +
            "rank：按rank升序，默认是timeDesc", required = false)
    private String order;
    
    /**
     * playback：回放列表 vod：点播列表，默认是playback
     */
    @ApiModelProperty(name = "listType", value = "playback：回放列表 vod：点播列表，默认是playback", required = false)
    private String listType;
    
}