package net.polyv.live.v1.service.children.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;

import lombok.extern.slf4j.Slf4j;
import net.polyv.live.v1.constant.LiveURL;
import net.polyv.live.v1.service.LiveBaseService;
import net.polyv.live.v1.service.children.ILiveChildrenService;
import net.polyv.live.v2.entity.user.children.LiveCreateOrganizationRequest;
import net.polyv.live.v2.entity.user.children.LiveCreateOrganizationResponse;
import net.polyv.live.v2.entity.user.children.LiveCreateUserChildrenRequest;
import net.polyv.live.v2.entity.user.children.LiveCreateUserChildrenResponse;
import net.polyv.live.v2.entity.user.children.LiveDeleteOrganizationRequest;
import net.polyv.live.v2.entity.user.children.LiveDeleteUserChildrenRequest;
import net.polyv.live.v2.entity.user.children.LiveGetChildrenRoleListRequest;
import net.polyv.live.v2.entity.user.children.LiveGetChildrenRoleListResponse;
import net.polyv.live.v2.entity.user.children.LiveGetOrganizationListRequest;
import net.polyv.live.v2.entity.user.children.LiveGetOrganizationListResponse;
import net.polyv.live.v2.entity.user.children.LiveGetUserChildrenRequest;
import net.polyv.live.v2.entity.user.children.LiveGetUserChildrenResponse;
import net.polyv.live.v2.entity.user.children.LiveUpdateUserChildrenRequest;

/**
 * 直播子账号管理
 * @author: jiangyifan
 */
@Slf4j
public class ILiveChildrenServiceImpl extends LiveBaseService implements ILiveChildrenService {
    
    @Override
    public LiveGetUserChildrenResponse getUserChildren(LiveGetUserChildrenRequest liveGetUserChildrenRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_GET_USER_CHILDREN_URL;
        return this.getReturnOne(url, liveGetUserChildrenRequest, LiveGetUserChildrenResponse.class);
    }
    
    /**
     * 新增子账号
     * API地址：https://help.polyv.net/#/live/api/v4/user/children/create
     * @param liveCreateUserChildrenRequest 新增子账号请求实体
     * @return 新增子账号响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveCreateUserChildrenResponse createUserChildren(
            LiveCreateUserChildrenRequest liveCreateUserChildrenRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_CREATE_USER_CHILDREN_URL;
        return this.postJsonBodyReturnOne(url, liveCreateUserChildrenRequest, LiveCreateUserChildrenResponse.class);
    }
    
    /**
     * 修改子账号
     * API地址：https://help.polyv.net/#/live/api/v4/user/children/update
     * @param liveUpdateUserChildrenRequest 修改子账号请求实体
     * @return 修改子账号响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean updateUserChildren(LiveUpdateUserChildrenRequest liveUpdateUserChildrenRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_UPDATE_USER_CHILDREN_URL;
        this.postJsonBodyReturnOne(url, liveUpdateUserChildrenRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 删除子账号
     * API地址：https://help.polyv.net/#/live/api/v4/user/children/delete
     * @param liveDeleteUserChildrenRequest 删除子账号请求实体
     * @return 删除子账号响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean deleteUserChildren(LiveDeleteUserChildrenRequest liveDeleteUserChildrenRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_DELETE_USER_CHILDREN_URL;
        this.postEmptyFormBodyReturnOne(url, liveDeleteUserChildrenRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 查询角色列表
     * API地址：https://help.polyv.net/#/live/api/v4/user/children/role/list
     * @param liveGetChildrenRoleListRequest 查询角色列表请求实体
     * @return 查询角色列表响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public List<LiveGetChildrenRoleListResponse> getChildrenRoleList(
            LiveGetChildrenRoleListRequest liveGetChildrenRoleListRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_GET_CHILDREN_ROLE_LIST_URL;
        return this.getReturnList(url, liveGetChildrenRoleListRequest, LiveGetChildrenRoleListResponse.class);
    }
    
    /**
     * 查询组织架构列表
     * API地址：https://help.polyv.net/#/live/api/v4/user/organization/list
     * @param liveGetOrganizationListRequest 查询组织架构列表请求实体
     * @return 查询组织架构列表响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public List<LiveGetOrganizationListResponse> getOrganizationList(
            LiveGetOrganizationListRequest liveGetOrganizationListRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_GET_ORGANIZATION_LIST_URL;
        return this.getReturnList(url, liveGetOrganizationListRequest, LiveGetOrganizationListResponse.class);
    }
    
    /**
     * 新增组织
     * API地址：https://help.polyv.net/#/live/api/v4/user/organization/create
     * @param liveCreateOrganizationRequest 新增组织请求实体
     * @return 新增组织响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveCreateOrganizationResponse createOrganization(
            LiveCreateOrganizationRequest liveCreateOrganizationRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_CREATE_ORGANIZATION_URL;
        return this.postJsonBodyReturnOne(url, liveCreateOrganizationRequest, LiveCreateOrganizationResponse.class);
    }
    
    /**
     * 删除组织
     * API地址：https://help.polyv.net/#/live/api/v4/user/organization/delete
     * @param liveDeleteOrganizationRequest 删除组织请求实体
     * @return 删除组织响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean deleteOrganization(LiveDeleteOrganizationRequest liveDeleteOrganizationRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_DELETE_ORGANIZATION_URL;
        this.postEmptyFormBodyReturnOne(url, liveDeleteOrganizationRequest, String.class);
        return Boolean.TRUE;
    }
    
}
