package net.polyv.live.v1.service;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;

import org.apache.http.HttpStatus;

import com.alibaba.fastjson.JSON;

import lombok.extern.slf4j.Slf4j;
import net.polyv.common.v1.constant.Constant;
import net.polyv.common.v1.exception.PloyvSdkException;
import net.polyv.common.v1.util.StringUtils;
import net.polyv.live.v1.entity.LiveCommonResponse;
import net.polyv.live.v1.entity.LiveResultCommonResponse;

/**
 * @author: sadboy
 **/
@Slf4j
public class LiveResultBaseService extends LiveBaseService{
    
    /**
     * 把http请求结果转换为LiveCommonResponse对象
     * @param response http请求返回值
     * @param requestId 该请求的
     * @return 直播标准返回参数
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 签名异常
     */
    @Override
    protected LiveCommonResponse responseConversion(String response, String requestId)
            throws IOException, NoSuchAlgorithmException {
        LiveCommonResponse liveCommonResponse;
        if (StringUtils.isNotBlank(response)) {
            LiveResultCommonResponse liveResultCommonResponse = JSON.parseObject(response, LiveResultCommonResponse.class);
            if (!"success".equals(liveResultCommonResponse.getStatus())) {
                String errorMessage = liveResultCommonResponse.getResult();
                int errorCode = HttpStatus.SC_BAD_REQUEST;
                String message = ERROR_PREFIX1 + requestId + ERROR_INFO + errorMessage;
                PloyvSdkException exception = new PloyvSdkException(errorCode , message);
                log.error(message, exception);
                throw exception;
            }
            liveCommonResponse = new LiveCommonResponse();
            liveCommonResponse.setCode(HttpStatus.SC_OK);
            liveCommonResponse.setSuccess(true);
            liveCommonResponse.setRequestId(requestId);
            liveCommonResponse.setData(liveResultCommonResponse.getResult());
        } else {
            String message = ERROR_PREFIX + requestId + ERROR_SUFFIX;
            PloyvSdkException exception = new PloyvSdkException(Constant.ERROR_CODE, message);
            log.error(message, exception);
            throw exception;
        }
        return liveCommonResponse;
    }
}
