package net.polyv.live.v1.entity.player;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.Max;
import net.polyv.common.v1.validator.constraints.Min;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 设置频道防录屏信息请求实体
 * @author jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("设置频道防录屏信息请求实体")
public class LiveSetAntiRecordRequest extends LiveCommonRequest {
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 防录屏方式 marquee：跑马灯 watermark：水印
     */
    @ApiModelProperty(name = "antiRecordType", value = "防录屏方式 marquee：跑马灯 watermark：水印", required = true)
    @NotNull(message = "属性antiRecordType不能为空")
    private String antiRecordType;
    
    /**
     * 防录屏类型，水印方式时设置自定义URL无效 fixed：固定值 nickname：登录用户名 diyurl：URL自定义跑马灯
     */
    @ApiModelProperty(name = "modelType", value = "防录屏类型，水印方式时设置自定义URL无效 fixed：固定值 nickname：登录用户名 diyurl：URL自定义跑马灯",
            required = true)
    @NotNull(message = "属性modelType不能为空")
    private String modelType;
    
    /**
     * 固定值时为设置内容 URL自定义设置时为网址，需要携带 http:// 或 https:// 【自定义跑马灯参考文档】 防录屏类型为登录用户名时可不传
     */
    @ApiModelProperty(name = "content", value = "固定值时为设置内容 URL自定义设置时为网址，需要携带 http:// 或 https:// 【自定义跑马灯参考文档】 " +
            "防录屏类型为登录用户名时可不传")
    private String content;
    
    /**
     * 字体大小 防录屏方式为跑马灯时：设置数值，范围1-256 防录屏方式为水印时： small：小 middle：中 large：大
     */
    @ApiModelProperty(name = "fontSize", value = "字体大小 防录屏方式为跑马灯时：设置数值，范围1-256 防录屏方式为水印时： small：小 middle：中 large：大",
            required = true)
    @NotNull(message = "属性fontSize不能为空")
    private String fontSize;
    
    /**
     * 透明度，不传默认为80，范围0-100，0为不透明
     */
    @ApiModelProperty(name = "opacity", value = "透明度，不传默认为80，范围0-100，0为不透明", required = false)
    @Min(value = 0, message = "透明度最小为0")
    @Max(value = 100, message = "透明度最大为100")
    private Integer opacity;
    
    /**
     * 跑马灯字体颜色，色值，例如：#FFFFFF
     */
    @ApiModelProperty(name = "fontColor", value = "跑马灯字体颜色，色值，例如：#FFFFFF", required = false)
    private String fontColor;
    
    /**
     * 跑马灯自定义缩放，默认为关闭 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "autoZoomEnabled", value = "跑马灯自定义缩放，默认为关闭 Y：开启 N：关闭", required = false)
    private String autoZoomEnabled;
    
    /**
     * 双跑马灯，默认为关闭 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "doubleEnabled", value = "双跑马灯，默认为关闭 Y：开启 N：关闭", required = false)
    private String doubleEnabled;
    
    /**
     * 跑马灯显示方式，默认为滚动 roll：滚动 flicker：闪烁
     */
    @ApiModelProperty(name = "showMode", value = "跑马灯显示方式，默认为滚动 roll：滚动 flicker：闪烁", required = false)
    private String showMode;
    
    /**
     * 防录屏开关，默认为开启
     * Y：开启
     * N：关闭
     */
    @ApiModelProperty(name = "enable", value = "防录屏开关，默认为开启 Y：开启 N：关闭", required = false)
    private String enable;
    
}