package net.polyv.live.v2.entity.user.children;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 删除组织请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("删除组织请求实体")
public class LiveDeleteOrganizationRequest extends LiveCommonRequest {
    
    /**
     * 组织ID，组织节点或子孙节点若存在子账号则不允许删除，若该组织节点存在子孙节点将全部删除
     */
    @ApiModelProperty(name = "organizationId", value = "组织ID，组织节点或子孙节点若存在子账号则不允许删除，若该组织节点存在子孙节点将全部删除", required = true)
    @NotNull(message = "属性organizationId不能为空")
    private Integer organizationId;
    
}