package net.polyv.live.v2.entity.channel.web.interact;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LivePageLimitCommonRequest;

/**
 * 查询多个频道抽奖记录请求实体
 * @author liyongxuan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询多个频道抽奖记录请求实体")
public class LiveListChannelsLotteryRequest extends LivePageLimitCommonRequest {
    /**
     * 频道号,多个频道使用“,”进行分割
     */
    @ApiModelProperty(name = "channelIds", value = "频道号,多个频道使用“,”进行分割", required = true)
    @NotNull(message = "属性channelIds不能为空")
    private String channelIds;
    
    /**
     * 查询的开始日期
     */
    @ApiModelProperty(name = "startTime", value = "查询的开始日期", required = true)
    @NotNull(message = "属性startTime不能为空")
    private Date startTime;
    
    /**
     * 查询的结束日期
     */
    @ApiModelProperty(name = "endTime", value = "查询的结束日期", required = true)
    @NotNull(message = "属性endTime不能为空")
    private Date endTime;
    
    /**
     * 要查询的直播场次ID，默认查询该频道中所有场次
     */
    @ApiModelProperty(name = "sessionId", value = "要查询的直播场次ID，默认查询该频道中所有场次", required = false)
    private String sessionId;
    
}