package net.polyv.live.v2.entity.channel.viewdata;

import java.util.Date;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 查询时间范围内频道直播观看详情数据响应实体
 * @author liyongxuan
 */
@Data
@Accessors(chain = true)
@ApiModel("查询时间范围内频道直播观看详情数据响应实体")
public class LiveDailySummaryResponse {
    
    /**
     * 查询日期
     */
    @ApiModelProperty(name = "currentDay", value = "查询日期", required = false)
    @JSONField(format = "yyyy-MM-dd")
    private Date currentDay;
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = false)
    private String channelId;
    
    /**
     * 直播账号ID
     */
    @ApiModelProperty(name = "userId", value = "直播账号ID", required = false)
    private String userId;
    
    /**
     * PC端播放时长，单位：分钟
     */
    @ApiModelProperty(name = "pcPlayDuration", value = "PC端播放时长，单位：分钟", required = false)
    private Integer pcPlayDuration;
    
    /**
     * PC端消耗流量，单位：bytes
     */
    @ApiModelProperty(name = "pcFlowSize", value = "PC端消耗流量，单位：bytes", required = false)
    private Long pcFlowSize;
    
    /**
     * PC端总播放量，类似PV
     */
    @ApiModelProperty(name = "pcVideoView", value = "PC端总播放量，类似PV", required = false)
    private Integer pcVideoView;
    
    /**
     * PC端唯一观众数，类似UV
     */
    @ApiModelProperty(name = "pcUniqueViewer", value = "PC端唯一观众数，类似UV", required = false)
    private Integer pcUniqueViewer;
    
    /**
     * 移动端播放时长，单位：分钟
     */
    @ApiModelProperty(name = "mobilePlayDuration", value = "移动端播放时长，单位：分钟", required = false)
    private Integer mobilePlayDuration;
    
    /**
     * 移动端消耗流量，单位：bytes
     */
    @ApiModelProperty(name = "mobileFlowSize", value = "移动端消耗流量，单位：bytes", required = false)
    private Long mobileFlowSize;
    
    /**
     * 移动端总播放量，类似PV
     */
    @ApiModelProperty(name = "mobileVideoView", value = "移动端总播放量，类似PV", required = false)
    private Integer mobileVideoView;
    
    /**
     * 移动端唯一观众数，类似UV
     */
    @ApiModelProperty(name = "mobileUniqueViewer", value = "移动端唯一观众数，类似UV", required = false)
    private Integer mobileUniqueViewer;
    
    /**
     * 记录添加的时间，13位毫秒级时间戳
     */
    @ApiModelProperty(name = "createdTime", value = "记录添加的时间", required = false)
    private Date createdTime;
    
    /**
     * 记录修改的时间，13位毫秒级时间戳
     */
    @ApiModelProperty(name = "lastModified", value = "记录修改的时间", required = false)
    private Date lastModified;
    
    /**
     * 创建账号的子账号用户ID（为空则为主账号创建）
     */
    @ApiModelProperty(name = "creatorId", value = "创建账号的子账号用户ID（为空则为主账号创建）", required = false)
    private String creatorId;
    
    /**
     * 创建频道的子账号名称（主账号创建的则显示"主账号"）
     */
    @ApiModelProperty(name = "creatorName", value = "创建频道的子账号名称（主账号创建的则显示\"主账号\"）", required = false)
    private String creatorName;
    
}