package net.polyv.live.v2.entity.channel.viewdata;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import net.polyv.live.v1.entity.LivePageCommonResponse;

/**
 * 查询后台频道统计信息响应实体
 * @author sadboy
 */
@Data
@Accessors(chain = true)
@ApiModel("查询后台频道统计信息响应实体")
public class LiveChannelStatisticResponse extends LivePageCommonResponse {
    
    /**
     * 频道统计视图对象
     */
    @ApiModelProperty(name = "contents", value = "频道统计视图对象", required = false)
    private ChannelStatistic contents;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("频道统计视图对象")
    public static class ChannelStatistic{
    
        /**
         * 人均观看时长，为(观看时长/观看人数)向下取整，单位:分钟
         */
        @ApiModelProperty(name = "averagePlayDuration", value = "人均观看时长，为(观看时长/观看人数)向下取整，单位:分钟", required = false)
        private Integer averagePlayDuration;
    
        /**
         * 人均观看次数，为(观看次数/观看人数)*10后向下取整后再除10，所以有一位小数，单位：次
         */
        @ApiModelProperty(name = "averageTime", value = "人均观看次数，为(观看次数/观看人数)*10后向下取整后再除10，所以有一位小数，单位：次", required = false)
        private Float averageTime;
        
        /**
         * 观看人数（根据ip地址去重）
         */
        @ApiModelProperty(name = "ips", value = "观看人数（根据ip地址去重）", required = false)
        private Integer ips;
        
        /**
         * 观看人数（根据viewerId计算）
         */
        @ApiModelProperty(name = "viewers", value = "观看人数（根据viewerId计算）", required = false)
        private Integer viewers;
        
        /**
         * 观看时长，单位:分钟
         */
        @ApiModelProperty(name = "playDuration", value = "观看时长，单位:分钟", required = false)
        private Integer playDuration;
        
        /**
         * 观看次数
         */
        @ApiModelProperty(name = "plays", value = "观看次数", required = false)
        private Integer plays;
        
        /**
         * 访问人数
         */
        @ApiModelProperty(name = "uniqueVisitor", value = "访问人数", required = false)
        private Integer uniqueVisitor;
        
    }

}
