package net.polyv.live.v2.entity.channel.statistics;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LivePageNumberCommonRequest;

/**
 * 查询频道中奖统计记录请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询频道中奖统计记录请求实体")
public class LiveGetLotteryListRequest extends LivePageNumberCommonRequest {
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 抽奖ID
     */
    @ApiModelProperty(name = "lotteryId", value = "抽奖ID", required = false)
    private String lotteryId;
    
    /**
     * 场次ID
     */
    @ApiModelProperty(name = "sessionId", value = "场次ID", required = false)
    private String sessionId;
    
    /**
     * 开始时间，13位毫秒级时间戳
     */
    @ApiModelProperty(name = "startTime", value = "开始时间，13位毫秒级时间戳", required = false)
    private Date startTime;
    
    /**
     * 结束时间，13位毫秒级时间戳
     */
    @ApiModelProperty(name = "endTime", value = "结束时间，13位毫秒级时间戳", required = false)
    private Date endTime;
    
}