package net.polyv.live.v2.entity.channel.player;

import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import net.polyv.live.v1.entity.LivePageCommonResponse;

/**
 * 查询投诉反馈响应实体
 * @author liyongxuan
 */
@Data
@Accessors(chain = true)
@ApiModel("查询投诉反馈响应实体")
public class LiveGetWatchFeedbackListResponse extends LivePageCommonResponse {
    
    /**
     * 当前页内容
     */
    @ApiModelProperty(name = "contents", value = "当前页内容", required = false)
    private List<LiveGetWatchFeedbackListResponse.FeedbackInfo> contents;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("当前页内容")
    public static class FeedbackInfo {
        /**
         * 投诉反馈ID
         */
        @ApiModelProperty(name = "id", value = "投诉反馈ID", required = false)
        private Integer id;
        
        /**
         * 频道号
         */
        @ApiModelProperty(name = "channelId", value = "频道号", required = false)
        private String channelId;
        
        /**
         * 投诉反馈类型 suggestion：反馈意见 complaint：投诉
         */
        @ApiModelProperty(name = "type", value = "投诉反馈类型 suggestion：反馈意见 complaint：投诉", required = false)
        private String type;
        
        /**
         * 所属分类 stuck：页面卡顿 black-screen：画面黑屏 slow-access：访问缓慢 poor-experience：体验不好 play-suggestion：玩法建议
         * other-feedback：其他反馈 porn：色情低俗 politics：涉政 drug：涉毒 bloody：恐怖血腥 scam：诈骗 other-violations：其他违规
         */
        @ApiModelProperty(name = "label", value = "所属分类 stuck：页面卡顿 black-screen：画面黑屏 slow-access：访问缓慢 " +
                "poor-experience：体验不好 play-suggestion：玩法建议 other-feedback：其他反馈 porn：色情低俗 politics：涉政 drug：涉毒 " +
                "bloody：恐怖血腥 scam：诈骗 other-violations：其他违规", required = false)
        private String label;
        
        /**
         * 内容
         */
        @ApiModelProperty(name = "content", value = "内容", required = false)
        private String content;
        
        /**
         * 图片URL列表
         */
        @ApiModelProperty(name = "imageUrls", value = "图片URL列表", required = false)
        private List<String> imageUrls;
        
        /**
         * 创建时间
         */
        @ApiModelProperty(name = "createTime", value = "创建时间", required = false)
        private Date createTime;
        
        /**
         * 更新时间
         */
        @ApiModelProperty(name = "updateTime", value = "更新时间", required = false)
        private Date updateTime;
    }
    
}