package net.polyv.live.v2.entity.channel.operate;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 修改频道关注公众号设置信息请求实体
 * @author liyongxuan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("修改频道关注公众号设置信息请求实体")
public class LiveUpdateChannelsFollowRequest extends LiveCommonRequest {
    /**
     * 频道号，多个频道用“,”分隔
     */
    @ApiModelProperty(name = "channelIds", value = "频道号，多个频道用“,”分隔", required = true)
    @NotNull(message = "属性channelIds不能为空")
    private String channelIds;
    
    /**
     * 图片链接地址
     */
    @ApiModelProperty(name = "qrCodeUrl", value = "图片链接地址", required = true)
    @NotNull(message = "属性qrCodeUrl不能为空")
    private String qrCodeUrl;
    
    /**
     * 关注公众号功能开关，为空不进行修改 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "enabled", value = "关注公众号功能开关，为空不进行修改 Y：开启 N：关闭", required = false)
    private String enabled;
    
    /**
     * 主动弹窗开关，为空不进行修改 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "autoShowEnabled", value = "主动弹窗开关，为空不进行修改 Y：开启 N：关闭", required = false)
    private String autoShowEnabled;
    
    /**
     * 入口文案，最大8个字符、为空是不进行修改
     */
    @ApiModelProperty(name = "entranceText", value = "入口文案，最大8个字符、为空是不进行修改", required = false)
    private String entranceText;
    
    /**
     * 弹窗提示文案，最大30个字符、为空是不进行修改
     */
    @ApiModelProperty(name = "tips", value = "弹窗提示文案，最大30个字符、为空是不进行修改", required = false)
    private String tips;
    
}