package net.polyv.live.v2.entity.channel.operate;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 获取频道关注公众号设置信息请求实体
 * @author liyongxuan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("获取频道关注公众号设置信息请求实体")
public class LiveListChannelsFollowRequest extends LiveCommonRequest {
    /**
     * 频道号,多个频道用“,”分隔
     */
    @ApiModelProperty(name = "channelIds", value = "频道号,多个频道用“,”分隔", required = true)
    @NotNull(message = "属性channelIds不能为空")
    private String channelIds;
    
}