package net.polyv.live.v2.entity.channel.doc;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 讲师文档关系管理请求实体
 * @author liyongxuan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("讲师文档关系管理请求实体")
public class LiveTeacherDocRelationRequest extends LiveCommonRequest {
    /**
     * 操作， 1：新增绑定关系，若绑定关系已经存在，则不再新增，只更新关联时间，查询列表时默认会根据此关联时间倒序排序 2：解除绑定关系
     */
    @ApiModelProperty(name = "operation", value = "操作， 1：新增绑定关系，若绑定关系已经存在，则不再新增，只更新关联时间，查询列表时默认会根据此关联时间倒序排序 2：解除绑定关系"
            , required = true)
    @NotNull(message = "属性operation不能为空")
    private Integer operation;
    
    /**
     * 讲师ID，32个以内ASCII码可见字符，系【创建频道接口】或【更新频道接口】所传入的 customTeacherId
     */
    @ApiModelProperty(name = "teacherId", value = "讲师ID，32个以内ASCII码可见字符，系【创建频道接口】或【更新频道接口】所传入的 customTeacherId",
            required = true)
    @NotNull(message = "属性teacherId不能为空")
    private String teacherId;
    
    /**
     * 文档ID，多个文档ID以,分隔，一次最多传入100个
     */
    @ApiModelProperty(name = "fileIds", value = "文档ID，多个文档ID以,分隔，一次最多传入100个", required = true)
    @NotNull(message = "属性fileIds不能为空")
    private String fileIds;
    
}