package net.polyv.live.v2.entity.channel.account;

import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.live.v1.entity.LivePageCommonResponse;

/**
 * 查询所有频道的基础信息响应实体
 * @author jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询所有频道的基础信息响应实体")
public class LiveListAccountBasicV2Response extends LivePageCommonResponse {
    
    /**
     * 查询的结果列表
     */
    @ApiModelProperty(name = "contents", value = "查询的结果列表", required = false)
    private List<LiveListAccountBasicV2Response.LiveChannelBasic> contents;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("查询的结果列表")
    public static class LiveChannelBasic {
        
        /**
         * 频道号
         */
        @ApiModelProperty(name = "channelId", value = "频道号", required = false)
        private String channelId;
        
        /**
         * 频道名称
         */
        @ApiModelProperty(name = "name", value = "频道名称", required = false)
        private String name;
        
        /**
         * 主持人名称
         */
        @ApiModelProperty(name = "publisher", value = "主持人名称", required = false)
        private String publisher;
        
        /**
         * 直播开始时间，关闭时为0
         */
        @ApiModelProperty(name = "startTime", value = "直播开始时间，关闭时为0", required = false)
        private Date startTime;
        
        /**
         * 页面累计观看数
         */
        @ApiModelProperty(name = "pageView", value = "页面累计观看数", required = false)
        private Integer pageView;
        
        /**
         * 观看页点赞数
         */
        @ApiModelProperty(name = "likes", value = "观看页点赞数", required = false)
        private Integer likes;
        
        /**
         * 频道图标url
         */
        @ApiModelProperty(name = "coverImg", value = "频道图标url", required = false)
        private String coverImg;
        
        /**
         * 频道引导图url
         */
        @ApiModelProperty(name = "splashImg", value = "频道引导图url", required = false)
        private String splashImg;
        
        /**
         * 引导页开关，取值 Y：开启 N：关闭
         */
        @ApiModelProperty(name = "splashEnabled", value = "引导页开关，取值 Y：开启 N：关闭", required = false)
        private String splashEnabled;
        
        /**
         * 直播介绍
         */
        @ApiModelProperty(name = "desc", value = "直播介绍", required = false)
        private String desc;
        
        /**
         * 最大在线观看人数
         */
        @ApiModelProperty(name = "maxViewer", value = "最大在线观看人数", required = false)
        private Integer maxViewer;
    
        /**
         * 频道的观看页状态，取值为 live：直播中 end：直播结束 playback：回放中 waiting：等待中 unStart：未开始
         */
        @ApiModelProperty(name = "watchStatus", value = "频道的观看页状态，取值为 live：直播中 end：直播结束 playback：回放中 waiting：等待中 unStart：未开始", required = false)
        private String watchStatus;
    
        /**
         * 观看页状态描述，直播中，回放中，已结束，等待中，未开始
         */
        @ApiModelProperty(name = "watchStatusText", value = "观看页状态描述，直播中，回放中，已结束，等待中，未开始", required = false)
        private String watchStatusText;
        
        /**
         * 在线人数
         */
        @ApiModelProperty(name = "onlineNum", value = "在线人数", required = false)
        private Integer onlineNum;
        
        /**
         * 暖场图片URL
         */
        @ApiModelProperty(name = "bgImg", value = "暖场图片URL", required = false)
        private String bgImg;
        
        /**
         * 分类ID
         */
        @ApiModelProperty(name = "categoryId", value = "分类ID", required = false)
        private Integer categoryId;
        
        /**
         * 回放视频列表，当有多个时按添加时间倒叙排列
         */
        @ApiModelProperty(name = "videoList", value = "回放视频列表，当有多个时按添加时间倒叙排列", required = false)
        private List<LiveListAccountBasicV2Response.BasicVideoList> videoList;
        
    }
    
    @Data
    @Accessors(chain = true)
    @ApiModel("回放视频列表，当有多个时按添加时间倒叙排列")
    public static class BasicVideoList {
        
        /**
         * 直播系统生成的id （视频库中的回放视频）
         */
        @ApiModelProperty(name = "videoId", value = "直播系统生成的id （视频库中的回放视频）", required = false)
        private String videoId;
        
        /**
         * 点播视频vid （视频库中的回放视频）
         */
        @ApiModelProperty(name = "videoPoolId", value = "点播视频vid （视频库中的回放视频）", required = false)
        private String videoPoolId;
    }
}