package net.polyv.live.v2.entity.channel.account;

import java.util.Date;
import java.util.List;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 查询频道信息响应实体
 * @author jiangyifan
 */
@Data
@Accessors(chain = true)
@ApiModel("查询频道信息响应实体")
public class LiveChannelBasicInfoV2Response {
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = false)
    private String channelId;
    
    /**
     * 频道名称
     */
    @ApiModelProperty(name = "name", value = "频道名称", required = false)
    private String name;
    
    /**
     * 直播场景：alone 活动拍摄；ppt 三分屏；topclass 大班课；seminar：研讨会
     */
    @ApiModelProperty(name = "scene", value = "直播场景：alone 活动拍摄；ppt 三分屏；topclass 大班课；seminar：研讨会", required = false)
    private String scene;
    
    /**
     * 新版后台直播场景，若未定义则取scene<br/>undefined：未定义<br/>topclass：大班课<br/>double：双师课（需开通权限）<br/>train：企业培训<br/>seminar
     * ：研讨会<br/>alone：活动营销
     */
    @ApiModelProperty(name = "newScene", value = "新版后台直播场景，若未定义则取scene<br/>undefined：未定义<br/>topclass：大班课<br/>double" +
            "：双师课（需开通权限）<br/>train：企业培训<br/>seminar：研讨会<br/>alone：活动营销", required = false)
    private String newScene;
    
    /**
     * 新版后台直播模板，若老版频道，该字段为未定义<br/>undefined：未定义<br/>ppt：文档+视频<br/>alone：纯视频(专业) <br/>topclass：纯视频(极速)
     * <br/>seminar：研讨会<br/>portrait_ppt：文档+视频(竖屏)<br/>portrait_alone：视频(竖屏)
     */
    @ApiModelProperty(name = "template", value = "新版后台直播模板，若老版频道，该字段为未定义<br/>undefined：未定义<br/>ppt：文档+视频<br/>alone" +
            "：纯视频(专业) <br/>topclass：纯视频(极速)<br/>seminar：研讨会<br/>portrait_ppt：文档+视频(竖屏)<br/>portrait_alone：视频(竖屏)",
            required = false)
    private String template;
    
    /**
     * 频道密码
     */
    @ApiModelProperty(name = "channelPasswd", value = "频道密码", required = false)
    private String channelPasswd;
    
    /**
     * 主持人名称
     */
    @ApiModelProperty(name = "publisher", value = "主持人名称", required = false)
    private String publisher;
    
    /**
     * 直播开始时间，关闭时为null
     */
    @ApiModelProperty(name = "startTime", value = "直播开始时间，关闭时为null", required = false)
    private Date startTime;
    
    /**
     * 直播结束时间，关闭时为null
     */
    @ApiModelProperty(name = "endTime", value = "直播结束时间", required = false)
    private Date endTime;
    
    /**
     * 页面累计观看数
     */
    @ApiModelProperty(name = "pageView", value = "页面累计观看数", required = false)
    private Integer pageView;
    
    /**
     * 观看页点赞数
     */
    @ApiModelProperty(name = "likes", value = "观看页点赞数", required = false)
    private Integer likes;
    
    /**
     * 频道图标url
     */
    @ApiModelProperty(name = "coverImg", value = "频道图标url", required = false)
    private String coverImg;
    
    /**
     * 频道引导图url
     */
    @ApiModelProperty(name = "splashImg", value = "频道引导图url", required = false)
    private String splashImg;
    
    /**
     * 引导页开关（取值为Y/N）
     */
    @ApiModelProperty(name = "splashEnabled", value = "引导页开关（取值为Y/N）", required = false)
    private String splashEnabled;
    
    /**
     * 直播介绍
     */
    @ApiModelProperty(name = "desc", value = "直播介绍", required = false)
    private String desc;
    
    /**
     * 咨询提问开关（取值为Y/N）
     */
    @ApiModelProperty(name = "consultingMenuEnabled", value = "咨询提问开关（取值为Y/N）", required = false)
    private String consultingMenuEnabled;
    
    /**
     * 限制最大在线观看人数开关（取值为Y/N）
     */
    @ApiModelProperty(name = "maxViewerRestrict", value = "限制最大在线观看人数开关（取值为Y/N）", required = false)
    private String maxViewerRestrict;
    
    /**
     * 最大在线观看人数
     */
    @ApiModelProperty(name = "maxViewer", value = "最大在线观看人数", required = false)
    private Integer maxViewer;
    
    /**
     * 观看页状态 live：直播中 playback：回放中 end：已结束 waiting：等待中 unStart：未开始
     * {@link net.polyv.live.v1.constant.LiveConstant.WatchStatus}
     */
    @ApiModelProperty(name = "watchStatus", value = "观看页状态 live：直播中 playback：回放中 end：已结束 waiting：等待中 unStart：未开始",
            required = false)
    private String watchStatus;
    
    /**
     * 观看页状态描述
     */
    @ApiModelProperty(name = "watchStatusText", value = "观看页状态描述", required = false)
    private String watchStatusText;
    
    @ApiModelProperty(name = "userCategory", value = "频道所属分类的信息", required = false)
    private LiveChannelBasicInfoV2Response.UserCategory userCategory;
    
    @ApiModelProperty(name = "authSettings", value = "直播观看条件列表", required = false)
    private List<LiveChannelBasicInfoV2Response.AuthSetting> authSettings;
    
    /**
     * 频道连麦人数限制
     */
    @ApiModelProperty(name = "linkMicLimit", value = "频道连麦人数限制", required = false)
    private Integer linkMicLimit;
    
    /**
     * 创建者账号id，为主账号创建时，返回主账号userId
     */
    @ApiModelProperty(name = "createdAccountId", value = "创建者账号id，为主账号创建时，返回主账号userId", required = false)
    private String createdAccountId;
    
    /**
     * 创建者账号邮箱
     */
    @ApiModelProperty(name = "createdAccountEmail", value = "创建者账号邮箱", required = false)
    private String createdAccountEmail;
    /**
     * 创建时间
     */
    @ApiModelProperty(name = "createdTime", value = "创建时间", required = false)
    private Date createdTime;
    
    /**
     * 客户端模版背景图URL
     */
    @ApiModelProperty(name = "clientAloneTemplateBackgroundUrl", value = "客户端模版背景图URL", required = false)
    private String clientAloneTemplateBackgroundUrl;
    
    /**
     * 视频混流背景图URL
     */
    @ApiModelProperty(name = "liveCdnBackgroundUrl", value = "视频混流背景图URL", required = false)
    private String liveCdnBackgroundUrl;
    
    @ApiModelProperty(name = "labelData", value = "标签id数组", required = false)
    private List<String> labelData;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("频道所属分类的信息")
    public static class UserCategory {
        
        /**
         * 分类ID
         */
        @ApiModelProperty(name = "categoryId", value = "分类ID", required = false)
        private Integer categoryId;
        
        /**
         * 分类名称
         */
        @ApiModelProperty(name = "categoryName", value = "分类名称", required = false)
        private String categoryName;
        
        /**
         * {@code POLYV用户ID，和保利威官网一致，获取路径：官网->登录->直播（开发设置）}
         */
        @ApiModelProperty(name = "userId", value = "POLYV用户ID，和保利威官网一致，获取路径：官网->登录->直播（开发设置）", required = false)
        private String userId;
        
        /**
         * 分类的排序值
         */
        @ApiModelProperty(name = "rank", value = "分类的排序值", required = false)
        private Integer rank;
        
    }
    
    @Data
    @Accessors(chain = true)
    @ApiModel("直播观看条件列表")
    public static class AuthSetting {
        
        /**
         * 频道号
         */
        @ApiModelProperty(name = "channelId", value = "频道号", required = false)
        private String channelId;
        
        /**
         * {@code POLYV用户ID，和保利威官网一致，获取路径：官网->登录->直播（开发设置）}
         */
        @ApiModelProperty(name = "userId", value = "POLYV用户ID，和保利威官网一致，获取路径：官网->登录->直播（开发设置）", required = false)
        private String userId;
        
        /**
         * 用于实现一个频道设置两个观看条件，为1或2（1为主要条件，2为次要条件）
         */
        @ApiModelProperty(name = "rank", value = "用于实现一个频道设置两个观看条件，为1或2（1为主要条件，2为次要条件）", required = false)
        private Integer rank;
        
        /**
         * 是否开启全局设置（Y/N）
         */
        @ApiModelProperty(name = "globalSettingEnabled", value = "是否开启全局设置（Y/N）", required = false)
        private String globalSettingEnabled;
        
        /**
         * 是否开启观看条件(Y/N)
         */
        @ApiModelProperty(name = "enabled", value = "是否开启观看条件(Y/N)", required = false)
        private String enabled;
        
        /**
         * 观看条件类型(1. 无限制 none 2. 验证码观看 code 3. 付费观看 pay 4. 白名单观看 phone 5. 登记观看 info 6. 分享观看 wxshare 7. 自定义授权观看 custom
         * 8. 外部授权观看 external)
         */
        @ApiModelProperty(name = "authType", value = "观看条件类型(1. 无限制 none 2. 验证码观看 code 3. 付费观看 pay 4. 白名单观看 phone 5. " +
                "登记观看 info 6. 分享观看 wxshare 7. 自定义授权观看 custom 8. 外部授权观看 external)", required = false)
        private String authType;
        
        /**
         * 白名单观看提示信息
         */
        @ApiModelProperty(name = "authTips", value = "白名单观看提示信息", required = false)
        private String authTips;
        
        /**
         * 付费观看提示信息
         */
        @ApiModelProperty(name = "payAuthTips", value = "付费观看提示信息", required = false)
        private String payAuthTips;
        
        /**
         * 验证码观看方式的验证码
         */
        @ApiModelProperty(name = "authCode", value = "验证码观看方式的验证码", required = false)
        private String authCode;
        
        /**
         * 验证码观看方式的二维码提示
         */
        @ApiModelProperty(name = "qCodeTips", value = "验证码观看方式的二维码提示", required = false)
        @JSONField(name = "qcodeTips")
        private String qCodeTips;
        
        /**
         * 验证码观看方式的二维码图片
         */
        @ApiModelProperty(name = "qCodeImg", value = "验证码观看方式的二维码图片", required = false)
        @JSONField(name = "qcodeImg")
        private String qCodeImg;
        
        /**
         * 付费观看的价格
         */
        @ApiModelProperty(name = "price", value = "付费观看的价格", required = false)
        private Float price;
        
        /**
         * 付费观看，截止时间，为null表示：一次付费，永久有效
         */
        @ApiModelProperty(name = "watchEndTime", value = "付费观看，截止时间，为null表示：一次付费，永久有效", required = false)
        private Date watchEndTime;
        
        /**
         * 付费观看的截止时长（天）
         */
        @ApiModelProperty(name = "validTimePeriod", value = "付费观看的截止时长（天）", required = false)
        private Integer validTimePeriod;
        
        /**
         * 自定义授权观看的key
         */
        @ApiModelProperty(name = "customKey", value = "自定义授权观看的key", required = false)
        private String customKey;
        
        /**
         * 自定义授权观看的接口地址
         */
        @ApiModelProperty(name = "customUri", value = "自定义授权观看的接口地址", required = false)
        private String customUri;
        
        /**
         * 外部授权观看的key
         */
        @ApiModelProperty(name = "externalKey", value = "外部授权观看的key", required = false)
        private String externalKey;
        
        /**
         * 外部授权观看的接口地址
         */
        @ApiModelProperty(name = "externalUri", value = "外部授权观看的接口地址", required = false)
        private String externalUri;
        
        /**
         * 外部授权观看，用户直接访问观看页时的跳转地址
         */
        @ApiModelProperty(name = "externalRedirectUri", value = "外部授权观看，用户直接访问观看页时的跳转地址", required = false)
        private String externalRedirectUri;
        
        /**
         * 独立授权key
         */
        @ApiModelProperty(name = "directKey", value = "独立授权key")
        private String directKey;
    
        /**
         * 试看开关，Y:开启试看，N:关闭试看
         */
        @ApiModelProperty(name = "trialWatchEnabled", value = "试看开关，Y:开启试看，N:关闭试看")
        private String trialWatchEnabled;
    
        /**
         * 试看时间，单位为分钟
         */
        @ApiModelProperty(name = "trialWatchTime", value = "试看时间，单位为分钟")
        private Integer trialWatchTime;
    
        /**
         * 试看截止日期，为null 表示对该频道永久有效
         */
        @ApiModelProperty(name = "trialWatchEndTime", value = "试看截止日期，为null 表示对该频道永久有效")
        private Date trialWatchEndTime;
        
        /**
         * 白名单输入提示
         */
        @ApiModelProperty(name = "whiteListInputTips", value = "白名单输入提示")
        private String whiteListInputTips;
        
        /**
         * 白名单入口文案
         */
        @ApiModelProperty(name = "whiteListEntryText", value = "白名单入口文案")
        private String whiteListEntryText;
        
        /**
         * 登记观看描述字段
         */
        @ApiModelProperty(name = "infoDesc", value = "登记观看描述字段")
        private String infoDesc;
        
        /**
         * 自定义讲师ID
         */
        @ApiModelProperty(name = "customTeacherId", value = "自定义讲师ID")
        private String customTeacherId;
    }
    
}