package net.polyv.live.v1.service.interact.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;

import lombok.extern.slf4j.Slf4j;
import net.polyv.live.v1.constant.LiveURL;
import net.polyv.live.v1.service.LiveBaseService;
import net.polyv.live.v1.service.interact.ILiveInvitePosterService;
import net.polyv.live.v2.entity.channel.statistics.LiveGetInviteStatsRequest;
import net.polyv.live.v2.entity.channel.statistics.LiveGetInviteStatsResponse;
import net.polyv.live.v2.entity.channel.web.interact.LiveCreateInviterRequest;
import net.polyv.live.v2.entity.channel.web.interact.LiveCreateInviterResponse;

/**
 * 邀请海报
 * @author: jiangyifan
 */
@Slf4j
public class ILiveInvitePosterServiceImpl extends LiveBaseService implements ILiveInvitePosterService {
    
    /**
     * 查询邀请海报明细数据
     * API地址：https://help.polyv.net/#/live/api/v4/channel/statistics/get_invite_stats
     * @param liveGetInviteStatsRequest 查询邀请海报明细数据请求实体
     * @return 查询邀请海报明细数据响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveGetInviteStatsResponse getInviteStats(LiveGetInviteStatsRequest liveGetInviteStatsRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_GET_INVITE_STATS_URL;
        return this.getReturnOne(url, liveGetInviteStatsRequest, LiveGetInviteStatsResponse.class);
    }
    
    /**
     * 创建邀请者
     * API地址：https://help.polyv.net/#/live/api/v4/channel/interaction/invite/inviter_create
     * @param liveCreateInviterRequest 创建邀请者请求实体
     * @return 创建邀请者响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveCreateInviterResponse createInviter(LiveCreateInviterRequest liveCreateInviterRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_CREATE_INVITER_URL;
        return this.postFormBodyReturnOne(url, liveCreateInviterRequest, LiveCreateInviterResponse.class);
    }
}
