package net.polyv.live.v1.service.channel.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSON;

import net.polyv.common.v1.util.MapUtil;
import net.polyv.live.v1.constant.LiveURL;
import net.polyv.live.v1.service.LiveBaseService;
import net.polyv.live.v1.service.channel.ILiveChannelDistributeService;
import net.polyv.live.v1.util.LiveSignUtil;
import net.polyv.live.v2.entity.channel.distribute.LiveChannelDistributeCreateRequest;
import net.polyv.live.v2.entity.channel.distribute.LiveChannelDistributeDeleteRequest;
import net.polyv.live.v2.entity.channel.distribute.LiveChannelDistributeListRequest;
import net.polyv.live.v2.entity.channel.distribute.LiveChannelDistributeListResponse;
import net.polyv.live.v2.entity.channel.distribute.LiveChannelDistributeStatisticRequest;
import net.polyv.live.v2.entity.channel.distribute.LiveChannelDistributeStatisticResponse;
import net.polyv.live.v2.entity.channel.distribute.LiveChannelDistributeUpdateRequest;
import net.polyv.live.v2.entity.channel.distribute.LiveDistributeUpdateMasterSwitchRequest;
import net.polyv.live.v2.entity.channel.distribute.LiveDistributeUpdateSwitchRequest;

/**
 * 云分发
 * @author: jiangyifan
 */
public class LiveChannelDistributeServiceImpl extends LiveBaseService implements ILiveChannelDistributeService {
    
    /**
     * 查询分发地址信息
     * API地址：https://help.polyv.net/#/live/api/v4/channel/distribute/list
     * @param liveChannelDistributeListRequest 查询分发地址信息请求实体
     * @return 查询分发地址信息响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveChannelDistributeListResponse listChannelDistribute(
            LiveChannelDistributeListRequest liveChannelDistributeListRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_CHANNEL_DISTRIBUTE_LIST_URL;
        return this.getReturnOne(url, liveChannelDistributeListRequest, LiveChannelDistributeListResponse.class);
    }
    
    /**
     * 批量添加分发地址
     * API地址：https://help.polyv.net/index.html#/live/api/v4/channel/distribute/create_batch
     * @param liveChannelDistributeCreateRequest 批量添加分发地址请求实体
     * @return 批量添加分发地址响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean createChannelDistribute(LiveChannelDistributeCreateRequest liveChannelDistributeCreateRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_CHANNEL_DISTRIBUTE_CREATE_BATCH_URL;
        Map<String, String> signMap = LiveSignUtil.getSignMap(liveChannelDistributeCreateRequest);
        signMap.put("channelId", liveChannelDistributeCreateRequest.getChannelId());
        url = MapUtil.appendUrl(url, signMap);
        this.postJsonBodyReturnOne(url, signMap, liveChannelDistributeCreateRequest,
                JSON.toJSONString(liveChannelDistributeCreateRequest.getContents()), String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 批量修改分分发地址
     * API地址：https://help.polyv.net/index.html#/live/api/v4/channel/distribute/update_batch
     * @param liveChannelDistributeUpdateRequest 批量修改分分发地址请求实体
     * @return 批量修改分分发地址响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean updateChannelDistribute(LiveChannelDistributeUpdateRequest liveChannelDistributeUpdateRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_CHANNEL_DISTRIBUTE_UPDATE_BATCH_URL;
        Map<String, String> signMap = LiveSignUtil.getSignMap(liveChannelDistributeUpdateRequest);
        signMap.put("channelId", liveChannelDistributeUpdateRequest.getChannelId());
        url = MapUtil.appendUrl(url, signMap);
        this.postJsonBodyReturnOne(url, signMap, liveChannelDistributeUpdateRequest,
                JSON.toJSONString(liveChannelDistributeUpdateRequest.getContents()), String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 批量删除分发地址
     * API地址：https://help.polyv.net/#/live/api/v4/channel/distribute/delete_batch
     * @param liveChannelDistributeDeleteRequest 批量删除分发地址请求实体
     * @return 批量删除分发地址响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean deleteChannelDistribute(LiveChannelDistributeDeleteRequest liveChannelDistributeDeleteRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_CHANNEL_DISTRIBUTE_DELETE_BATCH_URL;
        this.postEmptyFormBodyReturnOne(url, liveChannelDistributeDeleteRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 修改云分发频道总开关
     * API地址：https://help.polyv.net/index.html#/live/api/v4/channel/distribute/update-master-switch
     * @param liveDistributeUpdateMasterSwitchRequest 修改云分发频道总开关请求实体
     * @return 修改云分发频道总开关响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean updateMasterSwitch(LiveDistributeUpdateMasterSwitchRequest liveDistributeUpdateMasterSwitchRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_UPDATE_DISTRIBUTE_MASTER_SWITCH_URL;
        this.postEmptyFormBodyReturnOne(url, liveDistributeUpdateMasterSwitchRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 批量修改频道云分发开关
     * API地址：https://help.polyv.net/#/live/api/v4/channel/distribute/update-switch
     * @param liveDistributeUpdateSwitchRequest 批量修改频道云分发开关请求实体
     * @return 批量修改频道云分发开关响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean updateSwitch(LiveDistributeUpdateSwitchRequest liveDistributeUpdateSwitchRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_UPDATE_DISTRIBUTE_SWITCH_URL;
        this.postEmptyFormBodyReturnOne(url, liveDistributeUpdateSwitchRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 查询云分发数据信息
     * API地址：https://help.polyv.net/#/live/api/v4/channel/distribute/statistic
     * @param liveChannelDistributeStatisticRequest 查询云分发数据信息请求实体
     * @return 查询云分发数据信息响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public List<LiveChannelDistributeStatisticResponse> getDistributeStatistic(
            LiveChannelDistributeStatisticRequest liveChannelDistributeStatisticRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_CHANNEL_DISTRIBUTE_STATISTIC_URL;
        return this.getReturnList(url, liveChannelDistributeStatisticRequest,
                LiveChannelDistributeStatisticResponse.class);
    }
    
}
