package net.polyv.live.v1.service.channel.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSON;

import net.polyv.live.v1.constant.LiveURL;
import net.polyv.live.v1.entity.channel.advanced.LiveChannelRealtimeSubtitleLanguageRequest;
import net.polyv.live.v1.entity.channel.advanced.LiveChannelRealtimeSubtitleLanguageResponse;
import net.polyv.live.v1.entity.channel.advanced.LiveChannelRealtimeSubtitleRequest;
import net.polyv.live.v1.entity.channel.advanced.LiveChannelRealtimeSubtitleResponse;
import net.polyv.live.v1.entity.channel.advanced.LiveUpdateChannelRealtimeSubtitleRequest;
import net.polyv.live.v1.service.LiveBaseService;
import net.polyv.live.v1.service.channel.ILiveChannelAdvancedService;
import net.polyv.live.v1.util.LiveSignUtil;

/**
 * 字幕配置
 * @author sadboy
 */
public class LiveChannelAdvancedServiceImpl extends LiveBaseService implements ILiveChannelAdvancedService {
    
    /**
     * 查询频道的字幕配置
     * API地址：
     * @param req 查询频道的字幕配置请求实体
     * @return 查询频道的字幕配置响应实体
     * @throws IOException
     * @throws NoSuchAlgorithmException
     */
    @Override
    public LiveChannelRealtimeSubtitleResponse getConfig(LiveChannelRealtimeSubtitleRequest req)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_GET_REALTIME_SUBTITLE_SETTING_URL;
        return this.getReturnOne(url,req,LiveChannelRealtimeSubtitleResponse.class);
    }
    
    /**
     * 修改频道的字幕配置
     * API地址：
     * @param req 修改频道的字幕配置请求实体
     * @return 修改频道的字幕配置响应实体
     * @throws IOException
     * @throws NoSuchAlgorithmException
     */
    @Override
    public Boolean updateConfig(LiveUpdateChannelRealtimeSubtitleRequest req)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_UPDATE_REALTIME_SUBTITLE_SETTING_URL;
        Map<String, String> signMap = LiveSignUtil.getSignMap(req);
        String json = JSON.toJSONString(LiveSignUtil.getNotSignMap(req));
        this.postJsonBodyReturnOne(url, signMap, req, json, Object.class);
        return Boolean.TRUE;
    }
    
    /**
     * 查询实时字幕语言类型枚举
     * API地址：
     * @param req 查询实时字幕语言类型枚举请求实体
     * @return 查询实时字幕语言类型枚举返回实体
     * @throws IOException
     * @throws NoSuchAlgorithmException
     */
    @Override
    public List<LiveChannelRealtimeSubtitleLanguageResponse> getLanguage(LiveChannelRealtimeSubtitleLanguageRequest req)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_GET_REALTIME_SUBTITLE_LANGUAGE_URL;
        return this.getReturnList(url, req, LiveChannelRealtimeSubtitleLanguageResponse.class);
    }
    
}
