package net.polyv.live.v1.service.channel;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;

import net.polyv.live.v1.entity.channel.doc.LiveChannelDocStatusRequest;
import net.polyv.live.v1.entity.channel.doc.LiveChannelDocStatusResponse;
import net.polyv.live.v1.entity.channel.doc.LiveCreateChannelDocRequest;
import net.polyv.live.v1.entity.channel.doc.LiveCreateChannelDocResponse;
import net.polyv.live.v1.entity.channel.doc.LiveDeleteChannelDocRequest;
import net.polyv.live.v1.entity.channel.doc.LiveListChannelDocRequest;
import net.polyv.live.v1.entity.channel.doc.LiveListChannelDocResponse;
import net.polyv.live.v2.entity.channel.doc.LiveTeacherDocRelationRequest;

/**
 * 直播直播状态接口
 * @author: sadboy
 **/
public interface ILiveChannelDocService {
    
    /**
     * 获取频道文档列表
     * API地址：https://dev.polyv.net/2019/liveproduct/l-api/zbglgn/wdgl/get-ppt-list/
     * @param liveListChannelDocRequest 获取频道文档列表请求实体
     * @return 获取频道文档列表返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    LiveListChannelDocResponse listChannelDoc(LiveListChannelDocRequest liveListChannelDocRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 查询频道文档转换状态
     * API地址：https://dev.polyv.net/2019/liveproduct/l-api/zbglgn/wdgl/get-ppt-convert-status/
     * @param liveChannelDocStatusRequest 查询频道文档转换状态请求实体
     * @return 查询频道文档转换状态返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    LiveChannelDocStatusResponse getChannelDocStatus(LiveChannelDocStatusRequest liveChannelDocStatusRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 删除频道文档
     * API地址：https://dev.polyv.net/2019/liveproduct/l-api/zbglgn/wdgl/delete-document/
     * @param liveDeleteChannelDocRequest 删除频道文档请求实体
     * @return 删除频道文档返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean deleteChannelDoc(LiveDeleteChannelDocRequest liveDeleteChannelDocRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 上传频道文档
     * API地址：https://dev.polyv.net/2019/liveproduct/l-api/zbglgn/wdgl/upload-ppt-file/
     * @param liveCreateChannelDocRequest 上传频道文档请求实体
     * @return 上传频道文档返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    LiveCreateChannelDocResponse createChannelDoc(LiveCreateChannelDocRequest liveCreateChannelDocRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 讲师文档关系管理
     * API地址：https://help.polyv.net/#/live/api/channel/doc/update_teacher_doc_relation
     * @param liveTeacherDocRelationRequest 讲师文档关系管理请求实体
     * @return 讲师文档关系管理响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean UpdateTeacherDocRelation(LiveTeacherDocRelationRequest liveTeacherDocRelationRequest)
            throws IOException, NoSuchAlgorithmException;
    
}
